/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.concurrent;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.plugins.createcontent.concurrent.LazyInsertExecutor;
import com.atlassian.confluence.plugins.createcontent.concurrent.LazyInserter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterConcurrentLazyInsertExecutor
implements LazyInsertExecutor {
    private static final Logger log = LoggerFactory.getLogger(ClusterConcurrentLazyInsertExecutor.class);
    private final ClusterLockService lockService;

    public ClusterConcurrentLazyInsertExecutor(ClusterLockService lockService) {
        this.lockService = lockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lazyInsertAndRead(LazyInserter<T> inserter, String lockKey) {
        T result = inserter.read();
        if (result != null) {
            return result;
        }
        ClusterLock lock = this.lockService.getLockForName(lockKey);
        lock.lock();
        try {
            result = inserter.read();
            if (result != null) {
                log.debug("Read empty, but some other threads/instances inserted data while waiting for lock.");
                T t = result;
                return t;
            }
            log.debug("Read empty, re-read empty and insert data inside a lock.");
            T t = inserter.insert();
            return t;
        }
        finally {
            lock.unlock();
        }
    }
}

