AJS.$(function ($) {
    /*
        CONFDEV-11638 We want to know if people are using the 'Collector' pages as a
        navigational tool, so track clicks to pages. Only Content-Report macros created by
        us - with the hidden param 'analytics-key' - will be tracked, to try and reduce
        noise from collector pages the user creates themselves.
     */
    $('.content-report-table-macro').on('click', '.title a', function (event) {
        // (delegateTarget is the table, target is the anchor)
        var analyticsKey = $(event.delegateTarget).data('analytics-key');
        if (analyticsKey) {
            var eventName = 'content-report-table-macro.content-click.' + analyticsKey;
            AJS.trigger('analytics', {name: eventName});
        }
    });
});