/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.spaceproperty;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonSpaceProperty;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.SimpleValidationResults;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.SpacePropertyService;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.internal.spaces.SpaceManagerInternal;
import com.atlassian.confluence.plugins.contentproperty.JsonPropertyValidator;
import com.atlassian.confluence.plugins.contentproperty.StorageJsonPropertyManager;
import com.atlassian.confluence.plugins.contentproperty.spaceproperty.SpacePropertyFinderFactory;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.validation.Validation;
import com.atlassian.fugue.Option;
import com.atlassian.user.User;

public class SpacePropertyValidatorImpl
implements SpacePropertyService.Validator {
    private final SpaceManagerInternal spaceManager;
    private final PermissionManager permissionManager;
    private final SpacePropertyFinderFactory finderFactory;
    private final StorageJsonPropertyManager storageContentPropertyManager;

    public SpacePropertyValidatorImpl(SpaceManagerInternal spaceManager, PermissionManager permissionManager, SpacePropertyFinderFactory finderFactory, StorageJsonPropertyManager storageContentPropertyManager) {
        this.spaceManager = spaceManager;
        this.permissionManager = permissionManager;
        this.finderFactory = finderFactory;
        this.storageContentPropertyManager = storageContentPropertyManager;
    }

    public ValidationResult validateCreate(JsonSpaceProperty newProperty) {
        return Validation.success((Object)newProperty).applyValidation(prop -> this.validateKeyAndValue((JsonSpaceProperty)prop)).applyValidation(prop -> this.validateSpaceExistsInProperty((JsonSpaceProperty)prop)).applyValidation(prop -> this.validateSpaceFound((JsonSpaceProperty)prop).applyValidation(space -> this.validateCanView((JsonSpaceProperty)prop, space).applyValidation(x -> this.validateCanEdit((JsonSpaceProperty)x, space)))).applyValidation(prop -> this.validateDuplicate((JsonSpaceProperty)prop)).getValidationResult();
    }

    public ValidationResult validateUpdate(JsonSpaceProperty property) {
        return Validation.success((Object)property).applyValidation(prop -> this.validateKeyAndValue((JsonSpaceProperty)prop)).applyValidation(prop -> this.validateSpaceExistsInProperty((JsonSpaceProperty)prop).applyValidation(space -> this.validatePropertyFound((JsonSpaceProperty)prop)).applyValidation(propertyCEO -> this.validateCanView((JsonSpaceProperty)prop, propertyCEO).applyValidation(x -> this.validateCanEdit((JsonSpaceProperty)x, propertyCEO)).applyValidation(x -> this.validateVersionFound((JsonSpaceProperty)x)).applyValidation(x -> this.validateVersion((JsonSpaceProperty)x, (CustomContentEntityObject)propertyCEO)))).getValidationResult();
    }

    public ValidationResult validateDelete(JsonSpaceProperty property) {
        return Validation.success((Object)property).applyValidation(prop -> this.validateSpaceExistsInProperty((JsonSpaceProperty)prop)).applyValidation(prop -> this.validateKeyExistsInProperty((JsonSpaceProperty)prop)).applyValidation(prop -> this.validatePropertyFound((JsonSpaceProperty)prop).applyValidation(propertyCEO -> this.validateCanView((JsonSpaceProperty)prop, propertyCEO).applyValidation(x -> this.validateCanRemove((JsonSpaceProperty)prop, propertyCEO)))).getValidationResult();
    }

    private Validation<JsonSpaceProperty> validateKeyExistsInProperty(JsonSpaceProperty prop) {
        return prop.getKey() != null ? Validation.success((Object)prop) : Validation.fail((ValidationResult)SimpleValidationResult.builder().authorized(true).addError("jsonproperty.key.required", new Object[0]).build());
    }

    private Validation<JsonSpaceProperty> validateKeyAndValue(JsonSpaceProperty property) {
        SimpleValidationResult.Builder builder = SimpleValidationResult.builder();
        JsonPropertyValidator.validateKey(builder, property.getKey());
        JsonPropertyValidator.validateValue(builder, property.getKey(), property.getValue());
        return !builder.hasErrors() ? Validation.success((Object)property) : Validation.fail((ValidationResult)builder.authorized(true).build());
    }

    private Validation<JsonSpaceProperty> validateSpaceExistsInProperty(JsonSpaceProperty property) {
        return property.getSpaceRef().exists() ? Validation.success((Object)property) : Validation.fail((ValidationResult)SimpleValidationResult.builder().authorized(true).addError("spaceproperty.invalid.space", new Object[0]).build());
    }

    private Validation<Space> validateSpaceFound(JsonSpaceProperty property) {
        String spaceKey = property.getSpace().getKey();
        Space internalSpace = this.spaceManager.getSpace(spaceKey);
        return internalSpace != null ? Validation.success((Object)internalSpace) : Validation.fail((ValidationResult)SimpleValidationResults.notFoundResult((String)"spaceproperty.invalid.space", (Object[])new Object[]{property.getSpace().getKey()}));
    }

    private Validation<JsonSpaceProperty> validateCanView(JsonSpaceProperty property, Object target) {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, target) ? Validation.success((Object)property) : Validation.fail((ValidationResult)SimpleValidationResults.notFoundResult((String)"spaceproperty.invalid.space", (Object[])new Object[]{property.getSpace().getKey()}));
    }

    private Validation<JsonSpaceProperty> validateCanEdit(JsonSpaceProperty property, Object target) {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.EDIT, target) ? Validation.success((Object)property) : Validation.fail((ValidationResult)SimpleValidationResult.FORBIDDEN);
    }

    private Validation<JsonSpaceProperty> validateCanRemove(JsonSpaceProperty property, Object target) {
        return this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.REMOVE, target) ? Validation.success((Object)property) : Validation.fail((ValidationResult)SimpleValidationResult.FORBIDDEN);
    }

    private Validation<JsonSpaceProperty> validateDuplicate(JsonSpaceProperty property) {
        return !this.findProperty(property.getSpace().getKey(), property.getKey()).isDefined() ? Validation.success((Object)property) : Validation.fail((ValidationResult)SimpleValidationResults.conflictResult((String)"spaceproperty.duplicate.key", (Object[])new Object[0]));
    }

    private Validation<CustomContentEntityObject> validatePropertyFound(JsonSpaceProperty property) {
        CustomContentEntityObject storageContentProperty = this.storageContentPropertyManager.getStorageSpaceProperty(property);
        return storageContentProperty != null ? Validation.success((Object)storageContentProperty) : Validation.fail((ValidationResult)SimpleValidationResults.notFoundResult((String)"jsonproperty.invalid.property", (Object[])new Object[0]));
    }

    private Validation<JsonSpaceProperty> validateVersionFound(JsonSpaceProperty property) {
        return property.getVersion() != null ? Validation.success((Object)property) : Validation.fail((ValidationResult)SimpleValidationResult.builder().authorized(true).addError("jsonproperty.version.required", new Object[0]).build());
    }

    private Validation<JsonSpaceProperty> validateVersion(JsonSpaceProperty newProperty, CustomContentEntityObject oldPropertyCEO) {
        return newProperty.getVersion().getNumber() == oldPropertyCEO.getVersion() + 1 ? Validation.success((Object)newProperty) : Validation.fail((ValidationResult)SimpleValidationResults.conflictResult((String)"jsonproperty.version.conflict", (Object[])new Object[]{oldPropertyCEO.getVersion(), newProperty.getVersion().getNumber()}));
    }

    private Option<JsonSpaceProperty> findProperty(String spaceKey, String key) {
        return this.finderFactory.createSpacePropertyFinder(new Expansion("version")).withSpaceKey(spaceKey).withPropertyKey(key).fetchOne();
    }
}

