/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.search.query;

import com.atlassian.confluence.plugins.contentproperty.index.schema.ContentPropertySchemaField;
import com.atlassian.confluence.search.v2.BooleanOperator;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.QueryStringQuery;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;

public class TextQuery
implements SearchQuery {
    private static final String KEY = "content-property-text-field-type-query";
    private final ContentPropertySchemaField schemaField;
    private final String rawQuery;

    public TextQuery(ContentPropertySchemaField schemaField, String rawQuery) {
        Preconditions.checkArgument((schemaField != null ? 1 : 0) != 0, (Object)"Schema field must not be null.");
        this.schemaField = schemaField;
        this.rawQuery = rawQuery;
    }

    public String getKey() {
        return KEY;
    }

    public List<?> getParameters() {
        return ImmutableList.of((Object)this.schemaField, (Object)this.rawQuery);
    }

    public ContentPropertySchemaField getSchemaField() {
        return this.schemaField;
    }

    public String getRawQuery() {
        return this.rawQuery;
    }

    public SearchQuery expand() {
        return new QueryStringQuery(Collections.singleton(this.schemaField.getFieldName()), this.rawQuery, BooleanOperator.OR);
    }
}

