/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.search.query;

import com.atlassian.confluence.plugins.contentproperty.search.query.NumberRangeQuery;
import com.atlassian.confluence.search.v2.Range;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;

public class NumberRangeQueryMapper
implements LuceneQueryMapper<NumberRangeQuery> {
    public Query convertToLuceneQuery(NumberRangeQuery searchQuery) {
        Range<? extends Number> numberRange = searchQuery.getNumberRange();
        Double min = NumberRangeQuery.getDoubleOrNull((Number)numberRange.getFrom());
        Double max = NumberRangeQuery.getDoubleOrNull((Number)numberRange.getTo());
        return NumericRangeQuery.newDoubleRange((String)searchQuery.getSchemaField().getFieldName(), (Double)min, (Double)max, (boolean)numberRange.isIncludeFrom(), (boolean)numberRange.isIncludeTo());
    }
}

