/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.search.query;

import com.atlassian.confluence.plugins.contentproperty.index.schema.ContentPropertySchemaField;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.TermQuery;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MultiTermQuery
implements SearchQuery {
    private static final String KEY = "content-property-string-field-type-query";
    private final ContentPropertySchemaField schemaField;
    private final Set<String> values;

    public MultiTermQuery(ContentPropertySchemaField schemaField, Collection<String> values) {
        Preconditions.checkArgument((schemaField != null ? 1 : 0) != 0, (Object)"Schema field must not be null.");
        this.schemaField = schemaField;
        this.values = ImmutableSet.copyOf(values);
    }

    public String getKey() {
        return KEY;
    }

    public List<?> getParameters() {
        return ImmutableList.of((Object)this.schemaField, this.values);
    }

    public Set<String> getValues() {
        return this.values;
    }

    public ContentPropertySchemaField getSchemaField() {
        return this.schemaField;
    }

    public SearchQuery expand() {
        Set queries = this.values.stream().map(x -> new TermQuery(this.schemaField.getFieldName(), x)).collect(Collectors.toSet());
        return (SearchQuery)BooleanQuery.builder().addShould(queries).build();
    }
}

