/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.search.query;

import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.confluence.plugins.contentproperty.search.query.DateRangeQuery;
import com.atlassian.confluence.search.v2.Range;
import com.atlassian.confluence.search.v2.lucene.LuceneQueryMapper;
import java.util.Date;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRef;

public class DateRangeQueryMapper
implements LuceneQueryMapper<DateRangeQuery> {
    public Query convertToLuceneQuery(DateRangeQuery searchQuery) {
        Range<Date> dateRange = searchQuery.getDateRange();
        BytesRef lowerBound = null;
        BytesRef upperBound = null;
        if (dateRange.getFrom() != null) {
            lowerBound = new BytesRef((CharSequence)LuceneUtils.dateToString((Date)((Date)dateRange.getFrom())));
        }
        if (dateRange.getTo() != null) {
            upperBound = new BytesRef((CharSequence)LuceneUtils.dateToString((Date)((Date)dateRange.getTo())));
        }
        return new TermRangeQuery(searchQuery.getSchemaField().getFieldName(), lowerBound, upperBound, dateRange.isIncludeFrom(), dateRange.isIncludeTo());
    }
}

