/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.search.query;

import com.atlassian.confluence.plugins.contentproperty.index.schema.ContentPropertySchemaField;
import com.atlassian.confluence.search.v2.Range;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import java.util.List;

public class DateRangeQuery
implements SearchQuery {
    private static final String KEY = "content-property-date-field-type-query";
    private final ContentPropertySchemaField schemaField;
    private final Range<Date> dateRange;

    public DateRangeQuery(ContentPropertySchemaField schemaField, Range<Date> dateRange) {
        Preconditions.checkArgument((schemaField != null ? 1 : 0) != 0, (Object)"Schema field must not be null.");
        this.schemaField = schemaField;
        this.dateRange = dateRange;
    }

    public String getKey() {
        return KEY;
    }

    public List<?> getParameters() {
        return ImmutableList.of((Object)this.schemaField, this.dateRange);
    }

    public ContentPropertySchemaField getSchemaField() {
        return this.schemaField;
    }

    public Range<Date> getDateRange() {
        return this.dateRange;
    }

    public SearchQuery expand() {
        return com.atlassian.confluence.search.v2.query.DateRangeQuery.newDateRangeQuery((String)this.schemaField.getFieldName()).fromDate((Date)this.dateRange.getFrom()).toDate((Date)this.dateRange.getTo()).includeFrom(this.dateRange.isIncludeFrom()).includeTo(this.dateRange.isIncludeTo()).build();
    }
}

