/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.search.query;

import com.atlassian.confluence.plugins.contentproperty.index.descriptor.ContentPropertyFieldSort;
import com.atlassian.confluence.plugins.contentproperty.index.schema.ContentPropertySchemaField;
import com.atlassian.confluence.plugins.contentproperty.search.query.DateRangeQuery;
import com.atlassian.confluence.plugins.contentproperty.search.query.MultiTermQuery;
import com.atlassian.confluence.plugins.contentproperty.search.query.NumberRangeQuery;
import com.atlassian.confluence.plugins.contentproperty.search.query.TextQuery;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2FieldHandlerHelper;
import com.atlassian.confluence.plugins.cql.spi.v2searchhelpers.V2SearchQueryWrapper;
import com.atlassian.confluence.search.v2.Range;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.querylang.antlrgen.AqlParser;
import com.atlassian.querylang.fields.DateTimePrecision;
import com.atlassian.querylang.fields.expressiondata.ExpressionData;
import com.atlassian.querylang.lib.fields.expressiondata.ExpressionDataFactory;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.lucene.search.SortField;

public class ContentPropertySearchQueryFactory {
    private final ExpressionDataFactory factory = new ExpressionDataFactory();

    public V2SearchQueryWrapper create(ContentPropertySchemaField schemaField, Object value, AqlParser.MapExprValueContext valueContext) {
        switch (schemaField.getFieldType()) {
            case STRING: {
                return this.createStringSearchQuery(schemaField, (List)value, valueContext);
            }
            case DATE: {
                return this.createDateSearchQuery(schemaField, (DateTimePrecision)value, valueContext);
            }
            case NUMBER: {
                return this.createNumberRangeSearchQuery(schemaField, Double.valueOf(String.valueOf(value)), valueContext);
            }
            case TEXT: {
                return this.createTextSearchQuery(schemaField, (String)value, valueContext);
            }
        }
        throw new IllegalArgumentException(String.format("Could not create a search query for given schema field type '%s'", new Object[]{schemaField.getFieldType()}));
    }

    private V2SearchQueryWrapper createTextSearchQuery(ContentPropertySchemaField schemaField, String value, AqlParser.MapExprValueContext valueContext) {
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)new TextQuery(schemaField, value), (ExpressionData)this.factory.create(schemaField.getFieldName(), valueContext.textOp()));
    }

    private V2SearchQueryWrapper createStringSearchQuery(ContentPropertySchemaField schemaField, List<String> value, AqlParser.MapExprValueContext valueContext) {
        if (valueContext.value() != null) {
            return V2FieldHandlerHelper.wrapV2Search((SearchQuery)new MultiTermQuery(schemaField, value), (ExpressionData)this.factory.create(schemaField.getFieldName(), valueContext.eqOp()));
        }
        return V2FieldHandlerHelper.wrapV2Search((SearchQuery)new MultiTermQuery(schemaField, value), (ExpressionData)this.factory.create(schemaField.getFieldName(), valueContext.setOp()));
    }

    private V2SearchQueryWrapper createDateSearchQuery(ContentPropertySchemaField schemaField, DateTimePrecision value, AqlParser.MapExprValueContext valueContext) {
        if (valueContext.rangeOp() != null) {
            return new V2SearchQueryWrapper(this.buildDateRangeQuery(schemaField, valueContext.rangeOp(), value));
        }
        return new V2SearchQueryWrapper(this.buildDateRangeQuery(schemaField, valueContext.eqOp(), value));
    }

    private V2SearchQueryWrapper createNumberRangeSearchQuery(ContentPropertySchemaField schemaField, Double value, AqlParser.MapExprValueContext valueContext) {
        if (valueContext.rangeOp() != null) {
            return new V2SearchQueryWrapper(this.buildNumberRangeQuery(schemaField, valueContext.rangeOp(), value));
        }
        return new V2SearchQueryWrapper(this.buildNumberRangeQuery(schemaField, valueContext.eqOp(), value));
    }

    public SearchQuery buildNumberRangeQuery(ContentPropertySchemaField schemaField, AqlParser.RangeOpContext opCtx, Double value) {
        if (opCtx.OP_GT() != null) {
            return new NumberRangeQuery(schemaField, (Range<? extends Number>)Range.Builder.range(Double.class).greaterThan((Object)value));
        }
        if (opCtx.OP_GTEQ() != null) {
            return new NumberRangeQuery(schemaField, (Range<? extends Number>)Range.Builder.range(Double.class).greaterThanEquals((Object)value));
        }
        if (opCtx.OP_LT() != null) {
            return new NumberRangeQuery(schemaField, (Range<? extends Number>)Range.Builder.range(Double.class).lessThan((Object)value));
        }
        if (opCtx.OP_LTEQ() != null) {
            return new NumberRangeQuery(schemaField, (Range<? extends Number>)Range.Builder.range(Double.class).lessThanEquals((Object)value));
        }
        if (opCtx.OP_EQUALS() != null) {
            return new NumberRangeQuery(schemaField, (Range<? extends Number>)Range.Builder.range(Double.class).equalsOp((Object)value));
        }
        if (opCtx.OP_NOT_EQUALS() != null) {
            return V2FieldHandlerHelper.negate((SearchQuery)new NumberRangeQuery(schemaField, (Range<? extends Number>)Range.Builder.range(Double.class).equalsOp((Object)value)));
        }
        throw new IllegalArgumentException("Could not construct a number range query with given operator.");
    }

    public SearchQuery buildNumberRangeQuery(ContentPropertySchemaField schemaField, AqlParser.EqOpContext opCtx, Double value) {
        if (opCtx.OP_EQUALS() != null) {
            return new NumberRangeQuery(schemaField, (Range<? extends Number>)Range.Builder.range(Double.class).equalsOp((Object)value));
        }
        if (opCtx.OP_NOT_EQUALS() != null) {
            return V2FieldHandlerHelper.negate((SearchQuery)new NumberRangeQuery(schemaField, (Range<? extends Number>)Range.Builder.range(Double.class).equalsOp((Object)value)));
        }
        throw new IllegalArgumentException("Could not construct a number range query with given operator.");
    }

    private SearchQuery buildDateRangeQuery(ContentPropertySchemaField schemaField, AqlParser.EqOpContext opCtx, DateTimePrecision value) {
        if (opCtx.OP_EQUALS() != null) {
            return new DateRangeQuery(schemaField, (Range<Date>)Range.Builder.range(Date.class).equalsOp((Object)value.calcStartDateTimeInclusive().toDate(), (Object)value.calcEndDateTimeExclusive().toDate()));
        }
        if (opCtx.OP_NOT_EQUALS() != null) {
            return V2FieldHandlerHelper.negate((SearchQuery)new DateRangeQuery(schemaField, (Range<Date>)Range.Builder.range(Date.class).equalsOp((Object)value.calcStartDateTimeInclusive().toDate(), (Object)value.calcEndDateTimeExclusive().toDate())));
        }
        throw new IllegalArgumentException("Could not construct a date range query with given operator.");
    }

    private SearchQuery buildDateRangeQuery(ContentPropertySchemaField schemaField, AqlParser.RangeOpContext opCtx, DateTimePrecision value) {
        if (opCtx.OP_GT() != null) {
            return new DateRangeQuery(schemaField, (Range<Date>)Range.Builder.range(Date.class).greaterThanEquals((Object)value.calcEndDateTimeExclusive().toDate()));
        }
        if (opCtx.OP_GTEQ() != null) {
            return new DateRangeQuery(schemaField, (Range<Date>)Range.Builder.range(Date.class).greaterThanEquals((Object)value.calcStartDateTimeInclusive().toDate()));
        }
        if (opCtx.OP_LT() != null) {
            return new DateRangeQuery(schemaField, (Range<Date>)Range.Builder.range(Date.class).lessThan((Object)value.calcStartDateTimeInclusive().toDate()));
        }
        if (opCtx.OP_LTEQ() != null) {
            return new DateRangeQuery(schemaField, (Range<Date>)Range.Builder.range(Date.class).lessThan((Object)value.calcEndDateTimeExclusive().toDate()));
        }
        if (opCtx.OP_EQUALS() != null) {
            return new DateRangeQuery(schemaField, (Range<Date>)Range.Builder.range(Date.class).equalsOp((Object)value.calcStartDateTimeInclusive().toDate(), (Object)value.calcEndDateTimeExclusive().toDate()));
        }
        if (opCtx.OP_NOT_EQUALS() != null) {
            return V2FieldHandlerHelper.negate((SearchQuery)new DateRangeQuery(schemaField, (Range<Date>)Range.Builder.range(Date.class).equalsOp((Object)value.calcStartDateTimeInclusive().toDate(), (Object)value.calcEndDateTimeExclusive().toDate())));
        }
        throw new IllegalArgumentException("Could not construct a date range query with given operator.");
    }

    public SearchSort buildContentPropertySearchSort(ContentPropertySchemaField schemaField, SearchSort.Order order, SortField.Type type) {
        return new ContentPropertyFieldSort(order, schemaField.getFieldName(), type);
    }

    public <N extends Number> SearchQuery buildNumberRangeQuery(ContentPropertySchemaField schemaField, N from, N to, boolean includesFrom, boolean includesTo) {
        return new NumberRangeQuery(schemaField, (Range<? extends Number>)new Range(from, to, includesFrom, includesTo));
    }

    public SearchQuery buildStringEqualityQuery(ContentPropertySchemaField schemaField, String ... value) {
        return new MultiTermQuery(schemaField, Arrays.asList(value));
    }

    public SearchQuery buildTextSearchQuery(ContentPropertySchemaField schemaField, String value) {
        return new TextQuery(schemaField, value);
    }
}

