/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.index.schema;

import com.atlassian.confluence.plugins.contentproperty.index.schema.JsonField;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TextFieldTransformation
implements Function<JsonField, Option<IndexableField>> {
    private static final Logger log = LoggerFactory.getLogger(TextFieldTransformation.class);

    TextFieldTransformation() {
    }

    public Option<IndexableField> apply(JsonField input) {
        if (input.getNodeValue().isTextual()) {
            return Option.some((Object)new TextField(input.getFieldName(), input.getNodeValue().getTextValue(), Field.Store.NO));
        }
        log.debug("Couldn't transform JSON node to a text field type. Problematic node: {}", (Object)input.getNodeValue());
        return Option.none();
    }
}

