/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.index.schema;

import com.atlassian.confluence.plugins.contentproperty.index.schema.JsonField;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StringFieldTransformation
implements Function<JsonField, Option<IndexableField>> {
    private static final Logger log = LoggerFactory.getLogger(StringFieldTransformation.class);

    StringFieldTransformation() {
    }

    public Option<IndexableField> apply(JsonField input) {
        if (input.getNodeValue().isValueNode()) {
            return Option.some((Object)new StringField(input.getFieldName(), input.getNodeValue().asText(), Field.Store.NO));
        }
        log.debug("Couldn't transform JSON node to a string field type. Problematic node: {}", (Object)input.getNodeValue());
        return Option.none();
    }
}

