/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.index.schema;

import com.atlassian.confluence.plugins.contentproperty.index.schema.JsonField;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NumberFieldTransformation
implements Function<JsonField, Option<IndexableField>> {
    private static final Logger log = LoggerFactory.getLogger(NumberFieldTransformation.class);

    NumberFieldTransformation() {
    }

    public Option<IndexableField> apply(JsonField input) {
        if (input.getNodeValue().isNumber()) {
            return Option.some((Object)new DoubleField(input.getFieldName(), input.getNodeValue().getDoubleValue(), Field.Store.NO));
        }
        log.debug("Couldn't transform JSON node to a number field type. Problematic node: {}", (Object)input.getNodeValue());
        return Option.none();
    }
}

