/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.index.schema;

import com.atlassian.bonnie.LuceneUtils;
import com.atlassian.confluence.plugins.contentproperty.index.schema.JsonField;
import com.atlassian.fugue.Option;
import com.google.common.base.Function;
import java.util.Date;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.codehaus.jackson.JsonNode;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DateFieldTransformation
implements Function<JsonField, Option<IndexableField>> {
    private static final Logger log = LoggerFactory.getLogger(DateFieldTransformation.class);
    private static final DateTimeFormatter ISO8601_DATETIME_PARSER = ISODateTimeFormat.dateTimeParser();

    DateFieldTransformation() {
    }

    public Option<IndexableField> apply(JsonField input) {
        JsonNode jsonNode = input.getNodeValue();
        if (jsonNode.isLong() && jsonNode.getLongValue() > 0L) {
            return this.createFromLong(input.getFieldName(), jsonNode.getLongValue());
        }
        if (jsonNode.isTextual()) {
            return this.createFromString(input.getFieldName(), jsonNode.getTextValue());
        }
        log.debug("Couldn't transform JSON node to a date field type. Problematic node: {}", (Object)input.getNodeValue());
        return Option.none();
    }

    private Option<IndexableField> createFromDate(String fieldName, Date value) {
        return Option.some((Object)new StringField(fieldName, LuceneUtils.dateToString((Date)value), Field.Store.NO));
    }

    private Option<IndexableField> createFromLong(String fieldName, long value) {
        return this.createFromDate(fieldName, new DateTime(value).toDate());
    }

    private Option<IndexableField> createFromString(String fieldName, String value) {
        try {
            return this.createFromDate(fieldName, ISO8601_DATETIME_PARSER.parseDateTime(value).toDate());
        }
        catch (IllegalArgumentException e) {
            log.debug("Exception during date parsing occurred, {} did not match any registered datetime formats", (Object)value);
            return Option.none();
        }
    }
}

