/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty.index.extractor;

import com.atlassian.bonnie.Searchable;
import com.atlassian.bonnie.search.Extractor;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugin.module.SearchBodyProperty;
import com.atlassian.confluence.plugins.contentproperty.index.extractor.ContentPropertyExtractionManager;
import com.atlassian.confluence.plugins.contentproperty.index.schema.ContentPropertyIndexSchemaManager;
import com.atlassian.confluence.plugins.contentproperty.index.schema.ContentPropertySchemaField;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;

public class ContentPropertiesExtractor
implements Extractor {
    private final ContentPropertyIndexSchemaManager contentPropertyIndexSchemaManager;
    private final ContentPropertyExtractionManager contentPropertyExtractionManager;
    private final ContentPropertyService contentPropertyService;
    private final PermissionManager permissionManager;
    private final PluginAccessor pluginAccessor;

    public ContentPropertiesExtractor(ContentPropertyIndexSchemaManager contentPropertyIndexSchemaManager, ContentPropertyExtractionManager contentPropertyExtractionManager, ContentPropertyService contentPropertyService, PermissionManager permissionManager, PluginAccessor pluginAccessor) {
        this.contentPropertyIndexSchemaManager = contentPropertyIndexSchemaManager;
        this.contentPropertyExtractionManager = contentPropertyExtractionManager;
        this.contentPropertyService = contentPropertyService;
        this.permissionManager = permissionManager;
        this.pluginAccessor = pluginAccessor;
    }

    public void addFields(Document document, StringBuffer defaultSearchableText, Searchable searchable) {
        ContentEntityObject contentEntityObject;
        if (searchable instanceof ContentEntityObject && (contentEntityObject = (ContentEntityObject)searchable).getContentId() != null) {
            this.permissionManager.withExemption(() -> {
                Multimap<String, ContentPropertySchemaField> indexSchema = this.contentPropertyIndexSchemaManager.getIndexSchema();
                for (IndexableField indexableField : this.extractIndexableFields(contentEntityObject, indexSchema)) {
                    document.add(indexableField);
                }
            });
        }
        if (searchable instanceof CustomContentEntityObject) {
            for (SearchBodyProperty searchBodyProperty : this.pluginAccessor.getEnabledModulesByClass(SearchBodyProperty.class)) {
                CustomContentEntityObject entity = (CustomContentEntityObject)searchable;
                if (!entity.getContentTypeObject().equals((Object)searchBodyProperty.getContentType())) continue;
                this.permissionManager.withExemption(() -> this.addContentPropertyToSearchableText((CustomContentEntityObject)searchable, defaultSearchableText, searchBodyProperty.getContentProperty()));
            }
        }
    }

    private Iterable<IndexableField> extractIndexableFields(ContentEntityObject contentEntityObject, Multimap<String, ContentPropertySchemaField> indexSchema) {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (String key : indexSchema.keySet()) {
            Option jsonContentProperties;
            Collection contentPropertySchemaFields = Collections2.filter((Collection)indexSchema.get((Object)key), (Predicate)Predicates.notNull());
            if (contentPropertySchemaFields.isEmpty() || !(jsonContentProperties = this.contentPropertyService.find(new Expansion[0]).withContentId(contentEntityObject.getContentId()).withKey(key).fetchOne()).isDefined()) continue;
            resultBuilder.addAll(this.contentPropertyExtractionManager.extract(((JsonContentProperty)jsonContentProperties.get()).getValue(), contentPropertySchemaFields));
        }
        return resultBuilder.build();
    }

    @VisibleForTesting
    protected Void addContentPropertyToSearchableText(CustomContentEntityObject searchable, StringBuffer defaultSearchableText, String contentPropertyKey) {
        String value;
        Option jsonProperty = this.contentPropertyService.find(new Expansion[0]).withContentId(searchable.getContentId()).withPropertyKey(contentPropertyKey).fetchOne();
        JsonContentProperty jsonContentProperty = (JsonContentProperty)jsonProperty.getOrNull();
        if (jsonContentProperty != null && !Strings.isNullOrEmpty((String)(value = jsonContentProperty.getValue().getValue()))) {
            defaultSearchableText.setLength(0);
            defaultSearchableText.append(jsonContentProperty.getValue().getValue());
        }
        return null;
    }
}

