/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentSelector;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.Version;
import com.atlassian.confluence.api.model.messages.Message;
import com.atlassian.confluence.api.model.messages.SimpleMessage;
import com.atlassian.confluence.api.model.reference.Reference;
import com.atlassian.confluence.api.model.validation.ServiceExceptionSupplier;
import com.atlassian.confluence.api.model.validation.SimpleValidationResult;
import com.atlassian.confluence.api.model.validation.SimpleValidationResults;
import com.atlassian.confluence.api.model.validation.ValidationResult;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.exceptions.BadRequestException;
import com.atlassian.confluence.api.service.exceptions.ConflictException;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.contentproperty.ContentPropertyFinderFactory;
import com.atlassian.confluence.plugins.contentproperty.JsonPropertyValidator;
import com.atlassian.confluence.plugins.contentproperty.StorageJsonPropertyManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Option;
import com.atlassian.user.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

class ContentPropertyValidatorImpl
implements ContentPropertyService.Validator {
    private static final Logger log = LoggerFactory.getLogger(ContentPropertyValidatorImpl.class);
    private final CustomContentManager customContentManager;
    private final ContentEntityManager contentEntityManager;
    private final PermissionManager permissionManager;
    private final StorageJsonPropertyManager storageContentPropertyManager;
    private final ContentPropertyFinderFactory finderFactory;

    ContentPropertyValidatorImpl(CustomContentManager customContentManager, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, PermissionManager permissionManager, StorageJsonPropertyManager storageContentPropertyManager, ContentPropertyFinderFactory finderFactory) {
        this.customContentManager = customContentManager;
        this.contentEntityManager = contentEntityManager;
        this.permissionManager = permissionManager;
        this.storageContentPropertyManager = storageContentPropertyManager;
        this.finderFactory = finderFactory;
    }

    public ValidationResult validateCreate(JsonContentProperty newProperty) {
        SimpleValidationResult.Builder result = SimpleValidationResult.builder();
        String key = newProperty.getKey();
        JsonPropertyValidator.validateKey(result, key);
        JsonPropertyValidator.validateValue(result, key, newProperty.getValue());
        if (!newProperty.getContentRef().exists()) {
            result.addError("contentproperty.invalid.content", new Object[0]);
            result.authorized(true);
            return result.build();
        }
        ContentSelector selector = Content.getSelector((Reference)newProperty.getContentRef());
        try {
            Option<JsonContentProperty> existingProperty = this.findContentProperty(selector, key);
            if (existingProperty.isDefined()) {
                return new SimpleValidationResult.Builder().addMessage((Message)SimpleMessage.withKeyAndArgs((String)"jsonproperty.duplicate.key", (Object[])new Object[0])).addExceptionSupplier(ServiceExceptionSupplier.conflictException()).build();
            }
        }
        catch (NotFoundException e) {
            log.debug("Can't find/see content - will be detected by permissionManager check below");
        }
        catch (BadRequestException e) {
            log.debug("Can't resolve find request. Will be resolved to an invalid content/permission error below");
        }
        long storageContentId = selector.getId().asLong();
        ContentEntityObject storageContent = this.contentEntityManager.getById(storageContentId);
        if (storageContent == null) {
            result.addError("contentproperty.invalid.content", new Object[0]);
        }
        CustomContentEntityObject storageContentProperty = this.customContentManager.newPluginContentEntityObject("com.atlassian.confluence.plugins.confluence-content-property-storage:content-property");
        try {
            this.storageContentPropertyManager.updateStorageFromApi(newProperty, storageContentProperty);
            result.authorized(this.permissionManager.hasCreatePermission((User)this.getCurrentUser(), (Object)storageContent, (Object)storageContentProperty));
        }
        catch (ServiceException e) {
            result.authorized(true);
        }
        return result.build();
    }

    public ValidationResult validateUpdate(JsonContentProperty property) throws ConflictException {
        SimpleValidationResult.Builder result = SimpleValidationResult.builder();
        String key = property.getKey();
        JsonPropertyValidator.validateKey(result, key);
        JsonPropertyValidator.validateValue(result, key, property.getValue());
        ContentSelector selector = Content.getSelector((Reference)property.getContentRef());
        try {
            Option<JsonContentProperty> existingProperty = this.findContentProperty(selector, key);
            if (property.getId() != null && existingProperty.isDefined() && !((JsonContentProperty)existingProperty.get()).getId().equals((Object)property.getId())) {
                result.addError("jsonproperty.invalid.id", new Object[]{key});
            }
        }
        catch (NotFoundException e) {
            log.debug("Can't find/see content - will be detected by permissionManager check below");
        }
        catch (BadRequestException e) {
            log.debug("Can't resolve find request. Will be resolved to an invalid content/permission error below");
        }
        CustomContentEntityObject storageContentProperty = this.storageContentPropertyManager.getStorageContentProperty(result, property);
        if (storageContentProperty == null) {
            return SimpleValidationResults.notFoundResult((String)"Could not find Property to update.", (Object[])new Object[0]);
        }
        this.validateUpdateVersion(result, property, storageContentProperty);
        result.authorized(this.permissionManager.hasPermission((User)this.getCurrentUser(), Permission.EDIT, (Object)storageContentProperty));
        return result.build();
    }

    public ValidationResult validateDelete(JsonContentProperty property) {
        SimpleValidationResult.Builder result = SimpleValidationResult.builder();
        if (!property.getContentRef().exists()) {
            result.addError("contentproperty.invalid.content", new Object[0]);
        }
        CustomContentEntityObject storageContentProperty = this.storageContentPropertyManager.getStorageContentProperty(result, property);
        result.authorized(this.permissionManager.hasPermission((User)this.getCurrentUser(), Permission.REMOVE, (Object)storageContentProperty));
        return result.build();
    }

    private void validateUpdateVersion(SimpleValidationResult.Builder result, JsonContentProperty updatedProperty, CustomContentEntityObject oldProperty) throws ConflictException {
        Version newVersion = updatedProperty.getVersion();
        if (newVersion == null) {
            result.addError("jsonproperty.version.required", new Object[0]);
            return;
        }
        int expectedCurrentVersion = newVersion.getNumber() - 1;
        int currentVersion = oldProperty.getVersion();
        if (currentVersion != expectedCurrentVersion) {
            throw new ConflictException("You're trying to edit an outdated version of that ContentProperty. Latest version is " + currentVersion);
        }
    }

    private Option<JsonContentProperty> findContentProperty(ContentSelector selector, String key) throws BadRequestException, NotFoundException {
        return this.finderFactory.createContentPropertyFinder(new Expansion[0]).withContentId(selector.getId()).withKey(key).fetchOne();
    }

    private ConfluenceUser getCurrentUser() {
        return AuthenticatedUserThreadLocal.get();
    }
}

