/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.Expansions;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.content.id.JsonContentPropertyId;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.finder.ManyFetcher;
import com.atlassian.confluence.api.service.finder.SingleFetcher;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.plugins.contentproperty.JsonPropertyFactory;
import com.atlassian.confluence.plugins.contentproperty.JsonPropertyQueryFactory;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.fugue.Option;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.stream.StreamSupport;

class ContentPropertyFinderImpl
implements ContentPropertyService.ContentPropertyFinder,
SingleFetcher<JsonContentProperty>,
ManyFetcher<JsonContentProperty> {
    private final ContentService contentService;
    private final PaginationService paginationService;
    private final CustomContentManager customContentManager;
    private final PermissionManager permissionManager;
    private final JsonPropertyFactory jsonPropertyFactory;
    private final Expansions expansions;
    private JsonContentPropertyId contentPropertyId;
    private ContentId contentId;
    private String key;
    private List<ContentId> contentIds;
    private List<String> keys;

    public ContentPropertyFinderImpl(ContentService contentService, PaginationService paginationService, CustomContentManager customContentManager, PermissionManager permissionManager, JsonPropertyFactory jsonPropertyFactory, Expansion ... expansions) {
        this.contentService = contentService;
        this.paginationService = paginationService;
        this.customContentManager = customContentManager;
        this.permissionManager = permissionManager;
        this.jsonPropertyFactory = jsonPropertyFactory;
        this.expansions = new Expansions(expansions);
    }

    private Option<JsonContentProperty> findById() {
        CustomContentEntityObject result = this.customContentManager.getById(this.contentPropertyId.asLong());
        if (result == null || !this.permissionManager.hasPermission((User)this.getCurrentUser(), Permission.VIEW, (Object)result)) {
            return Option.none();
        }
        return Option.some((Object)this.jsonPropertyFactory.buildContentPropertyFrom(result, this.expansions));
    }

    private PageResponse<JsonContentProperty> findAllByContentId(PageRequest request) throws NotFoundException {
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)request, (int)100);
        Option contentOption = this.contentService.find(this.expansions.getSubExpansions("content").toArray()).withId(this.contentId).fetchOne();
        if (contentOption.isEmpty()) {
            throw new NotFoundException("Cannot find content with id " + this.contentId);
        }
        Content content = (Content)contentOption.get();
        Function<CustomContentEntityObject, JsonContentProperty> modelConverter = this.jsonPropertyFactory.buildContentPropertyFromFunction(content, this.expansions);
        return this.paginationService.doPaginationListRequest(limitedRequest, from -> this.customContentManager.findByQuery(JsonPropertyQueryFactory.findAllByContentId(this.contentId.asLong()), true, from, this.hasViewPermission()), items -> Iterables.transform((Iterable)items, arg_0 -> ((Function)modelConverter).apply(arg_0)));
    }

    private PageResponse<JsonContentProperty> findAllByContentIdsAndKeys(PageRequest request) {
        List ids = this.contentIds != null && !this.contentIds.isEmpty() ? Lists.transform(this.contentIds, ContentId::asLong) : Lists.newArrayList((Object[])new Long[]{this.contentId.asLong()});
        LimitedRequest limitedRequest = LimitedRequestImpl.create((PageRequest)request, (int)100);
        Function<CustomContentEntityObject, JsonContentProperty> modelConverter = this.jsonPropertyFactory.buildContentPropertyFromFunction();
        return this.paginationService.doPaginationListRequest(limitedRequest, from -> this.customContentManager.findByQuery(JsonPropertyQueryFactory.findAllByContentIdsAndKeys(ids, this.keys), true, from, this.hasViewPermission()), items -> Iterables.transform((Iterable)items, arg_0 -> ((Function)modelConverter).apply(arg_0)));
    }

    private Option<JsonContentProperty> findByContentIdAndKey() {
        CustomContentEntityObject result = (CustomContentEntityObject)this.customContentManager.findFirstObjectByQuery(JsonPropertyQueryFactory.findByContentIdAndKey(this.contentId.asLong(), this.key));
        if (result == null || !this.permissionManager.hasPermission((User)this.getCurrentUser(), Permission.VIEW, (Object)result)) {
            return Option.none();
        }
        return Option.some((Object)this.jsonPropertyFactory.buildContentPropertyFrom(result, this.expansions));
    }

    public ContentPropertyService.ParameterContentPropertyFinder withContentId(ContentId contentId) {
        this.contentId = contentId;
        return this;
    }

    public ContentPropertyService.ParameterContentPropertyFinder withContentIds(List<ContentId> contentIds) {
        this.contentIds = contentIds;
        return this;
    }

    public ContentPropertyService.ParameterContentPropertyFinder withKey(String key) {
        return this.withPropertyKey(key);
    }

    public ContentPropertyService.ParameterContentPropertyFinder withPropertyKey(String key) {
        this.key = key;
        return this;
    }

    public ContentPropertyService.ParameterContentPropertyFinder withPropertyKeys(List<String> keys) {
        this.keys = keys;
        return this;
    }

    public ContentPropertyService.SingleContentPropertyFetcher withId(JsonContentPropertyId contentPropertyId) {
        this.contentPropertyId = contentPropertyId;
        return this;
    }

    public PageResponse<JsonContentProperty> fetchMany(PageRequest request) throws NotFoundException {
        if (this.keys != null && (this.contentId != null || this.contentIds != null)) {
            return this.findAllByContentIdsAndKeys(request);
        }
        if (this.contentId != null) {
            return this.findAllByContentId(request);
        }
        throw new IllegalArgumentException("Must specify contentId, or contentIds and keys");
    }

    public Option<JsonContentProperty> fetchOne() throws IllegalArgumentException {
        if (this.contentPropertyId != null) {
            return this.findById();
        }
        if (this.contentId != null && this.key != null) {
            return this.findByContentIdAndKey();
        }
        throw new IllegalArgumentException("Must specify either a contentPropertyId, or a contentId and a key");
    }

    public Iterator<String> fetchPropertyKeys() {
        if (this.contentId != null) {
            Option contentOption = this.contentService.find(new Expansion[0]).withId(this.contentId).fetchOne();
            if (contentOption.isEmpty()) {
                throw new NotFoundException("Cannot find content with id " + this.contentId);
            }
            Iterable iterable = () -> this.customContentManager.findAllContainedOfType(this.contentId.asLong(), "com.atlassian.confluence.plugins.confluence-content-property-storage:content-property");
            return StreamSupport.stream(iterable.spliterator(), false).map(cceo -> cceo.getTitle()).iterator();
        }
        throw new IllegalArgumentException("Must specify a contentId");
    }

    public JsonContentProperty fetchOneOrNull() {
        Option<JsonContentProperty> propOption = this.fetchOne();
        return (JsonContentProperty)propOption.getOrNull();
    }

    private ConfluenceUser getCurrentUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    private Predicate<CustomContentEntityObject> hasViewPermission() {
        return target -> this.permissionManager.hasPermission((User)this.getCurrentUser(), Permission.VIEW, target);
    }
}

