/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.contentproperty;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.JsonContentProperty;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.model.content.id.JsonContentPropertyId;
import com.atlassian.confluence.api.service.content.ContentPropertyService;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.api.service.exceptions.NotFoundException;
import com.atlassian.confluence.api.service.pagination.PaginationService;
import com.atlassian.confluence.content.CustomContentManager;
import com.atlassian.confluence.plugins.contentproperty.ContentPropertyFinderImpl;
import com.atlassian.confluence.plugins.contentproperty.JsonPropertyFactory;
import com.atlassian.confluence.plugins.contentproperty.TransactionWrappingFinder;
import com.atlassian.confluence.plugins.contentproperty.transaction.ThrowingTransactionCallback;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spring.transaction.interceptor.TransactionalHostContextAccessor;
import java.util.Iterator;
import java.util.List;

public class ContentPropertyFinderFactory {
    private final ContentService contentService;
    private final PaginationService paginationService;
    private final CustomContentManager customContentManager;
    private final PermissionManager permissionManager;
    private final JsonPropertyFactory jsonPropertyFactory;
    private final TransactionalHostContextAccessor hostContextAccessor;

    public ContentPropertyFinderFactory(ContentService contentService, PaginationService paginationService, CustomContentManager customContentManager, PermissionManager permissionManager, JsonPropertyFactory jsonPropertyFactory, TransactionalHostContextAccessor hostContextAccessor) {
        this.contentService = contentService;
        this.paginationService = paginationService;
        this.customContentManager = customContentManager;
        this.permissionManager = permissionManager;
        this.jsonPropertyFactory = jsonPropertyFactory;
        this.hostContextAccessor = hostContextAccessor;
    }

    public ContentPropertyService.ContentPropertyFinder createContentPropertyFinder(Expansion ... expansions) {
        ContentPropertyFinderImpl rawFinder = new ContentPropertyFinderImpl(this.contentService, this.paginationService, this.customContentManager, this.permissionManager, this.jsonPropertyFactory, expansions);
        return new TransactionWrappingContentFinder(rawFinder, this.hostContextAccessor);
    }

    private static class TransactionWrappingContentFinder
    extends TransactionWrappingFinder<JsonContentProperty>
    implements ContentPropertyService.ContentPropertyFinder {
        private final ContentPropertyService.ContentPropertyFinder delegate;

        public TransactionWrappingContentFinder(ContentPropertyFinderImpl delegate, TransactionalHostContextAccessor hostContextAccessor) {
            super(delegate, delegate, hostContextAccessor);
            this.delegate = delegate;
        }

        public ContentPropertyService.ParameterContentPropertyFinder withKey(String key) {
            this.delegate.withPropertyKey(key);
            return this;
        }

        public ContentPropertyService.ParameterContentPropertyFinder withPropertyKey(String key) {
            this.delegate.withPropertyKey(key);
            return this;
        }

        public ContentPropertyService.ParameterContentPropertyFinder withPropertyKeys(List<String> keys) {
            this.delegate.withPropertyKeys(keys);
            return this;
        }

        public ContentPropertyService.SingleContentPropertyFetcher withId(JsonContentPropertyId contentPropertyId) {
            this.delegate.withId(contentPropertyId);
            return this;
        }

        public ContentPropertyService.ParameterContentPropertyFinder withContentId(ContentId contentId) {
            this.delegate.withContentId(contentId);
            return this;
        }

        public ContentPropertyService.ParameterContentPropertyFinder withContentIds(List<ContentId> contentIds) {
            return this.delegate.withContentIds(contentIds);
        }

        public Iterator<String> fetchPropertyKeys() {
            ThrowingTransactionCallback<Iterator<String>, NotFoundException> callback = new ThrowingTransactionCallback<Iterator<String>, NotFoundException>(){

                @Override
                public Iterator<String> doInTransaction() throws NotFoundException {
                    return delegate.fetchPropertyKeys();
                }
            };
            return this.executeReadOnly(callback);
        }
    }
}

