/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.recipients;

import com.atlassian.annotations.ExperimentalSpi;
import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationPayload;
import com.atlassian.confluence.notifications.PayloadBasedNotification;
import com.atlassian.confluence.notifications.batch.service.BatchingRecipientsProvider;
import com.atlassian.confluence.notifications.content.AuthenticatedRecipientProvider;
import com.atlassian.confluence.notifications.content.CommonContentExpansions;
import com.atlassian.confluence.notifications.content.ContentIdPayload;
import com.atlassian.confluence.notifications.content.SimpleContentIdPayload;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Function;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Qualifier;

@ExperimentalSpi
public class SpaceRecipientsProvider
extends AuthenticatedRecipientProvider<ContentIdPayload>
implements BatchingRecipientsProvider<ContentIdPayload> {
    private final SpaceManager spaceManager;
    private final ContentService contentService;

    public SpaceRecipientsProvider(TransactionTemplate transactionTemplate, NotificationManager notificationManager, PageManager pageManager, SpaceManager spaceManager, ContentService contentService, UserAccessor userAccessor, PermissionManager permissionManager, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, ConfluenceAccessManager confluenceAccessManager) {
        super(transactionTemplate, notificationManager, pageManager, userAccessor, permissionManager, contentEntityManager, confluenceAccessManager);
        this.spaceManager = spaceManager;
        this.contentService = contentService;
    }

    private ContentTypeEnum getContentTypeEnum(String contentType) {
        ContentTypeEnum contentTypeEnum = ContentTypeEnum.getByRepresentation((String)contentType);
        if ("page".equals(contentType) || "blogpost".equals(contentType) || "comment".equals(contentType)) {
            contentTypeEnum = null;
        }
        return contentTypeEnum;
    }

    @Override
    protected Iterable<com.atlassian.confluence.mail.notification.Notification> computeNotificationsInContextOfNotifier(Notification<ContentIdPayload> notification) {
        final ContentIdPayload payload = (ContentIdPayload)notification.getPayload();
        final ContentTypeEnum contentType = this.getContentTypeEnum(payload.getContentType().getType());
        return (Iterable)this.contentService.find(new Expansion[]{CommonContentExpansions.SPACE}).withId(ContentId.of((ContentType)payload.getContentType(), (long)payload.getContentId())).fetchOne().map((Function)new Function<Content, Iterable<com.atlassian.confluence.mail.notification.Notification>>(){

            public Iterable<com.atlassian.confluence.mail.notification.Notification> apply(Content input) {
                Space space = SpaceRecipientsProvider.this.spaceManager.getSpace(input.getSpace().getKey());
                return SpaceRecipientsProvider.this.permissionFiltered(SpaceRecipientsProvider.this.notificationManager.getNotificationsBySpaceAndType(space, contentType), payload.getContentId());
            }
        }).getOrElse((Object)Collections.EMPTY_LIST);
    }

    public Iterable<RoleRecipient> batchUserBasedRecipientsFor(String randomOriginatorUserKey, String id, String contentType) {
        ContentType confContentType;
        switch (contentType) {
            case "page": {
                confContentType = ContentType.PAGE;
                break;
            }
            case "blogpost": {
                confContentType = ContentType.BLOG_POST;
                break;
            }
            case "comment": {
                confContentType = ContentType.COMMENT;
                break;
            }
            default: {
                return Collections.emptyList();
            }
        }
        ContentId contentId = ContentId.deserialise((String)id);
        PayloadBasedNotification fakeNotification = new PayloadBasedNotification((NotificationPayload)new SimpleContentIdPayload(confContentType, contentId.asLong(), randomOriginatorUserKey), null);
        return this.computeUserBasedRecipients(fakeNotification);
    }
}

