/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content.impl;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.service.content.ContentService;
import com.atlassian.confluence.notifications.NotificationContentCacheKey;
import com.atlassian.confluence.notifications.content.BodyContentRenderedEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.util.concurrent.NotNull;

@Internal
public class ContentCacheLoader {
    private final ContentService contentService;
    private final EventPublisher eventPublisher;

    public ContentCacheLoader(ContentService contentService, EventPublisher eventPublisher) {
        this.contentService = contentService;
        this.eventPublisher = eventPublisher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Option<Content> load(@NotNull NotificationContentCacheKey cacheKey) {
        Option contents = Option.none();
        try {
            Option option = contents = this.contentService.find(cacheKey.getExpansions()).withId(cacheKey.getContentId()).fetchOne();
            return option;
        }
        finally {
            if (contents.isDefined()) {
                this.eventPublisher.publish((Object)new BodyContentRenderedEvent(cacheKey));
            }
        }
    }
}

