/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.notifications.ConfluenceUserRole;
import com.atlassian.confluence.notifications.Notification;
import com.atlassian.confluence.notifications.NotificationPayload;
import com.atlassian.confluence.notifications.RecipientsProviderTemplate;
import com.atlassian.confluence.notifications.content.WatchTypeUtil;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.api.medium.recipient.UserKeyRoleRecipient;
import com.atlassian.plugin.notifications.spi.UserRole;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;

public abstract class WatchTypeBasedRecipientProvider<PAYLOAD extends NotificationPayload>
extends RecipientsProviderTemplate<PAYLOAD> {
    protected final TransactionTemplate transactionTemplate;
    protected final NotificationManager notificationManager;
    protected final PageManager pageManager;
    private final PermissionManager permissionManager;
    private final ContentEntityManager contentEntityManager;
    private final ConfluenceAccessManager confluenceAccessManager;

    public WatchTypeBasedRecipientProvider(TransactionTemplate transactionTemplate, NotificationManager notificationManager, PageManager pageManager, PermissionManager permissionManager, ContentEntityManager contentEntityManager, ConfluenceAccessManager confluenceAccessManager) {
        this.transactionTemplate = transactionTemplate;
        this.notificationManager = notificationManager;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.contentEntityManager = contentEntityManager;
        this.confluenceAccessManager = confluenceAccessManager;
    }

    public Iterable<UserRole> getUserRoles() {
        return WatchTypeUtil.watchTypesToUserRoles();
    }

    protected Iterable<RoleRecipient> computeUserBasedRecipients(final Notification<PAYLOAD> notification) {
        return (Iterable)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Iterable<RoleRecipient>>(){

            public Iterable<RoleRecipient> doInTransaction() {
                ImmutableList.Builder roleRecipientBuilder = ImmutableList.builder();
                for (com.atlassian.confluence.mail.notification.Notification fatNotification : WatchTypeBasedRecipientProvider.this.computeNotifications(notification)) {
                    ConfluenceUserRole role = new ConfluenceUserRole(fatNotification.getWatchType().name());
                    UserKey userKey = fatNotification.getReceiver().getKey();
                    roleRecipientBuilder.add((Object)new UserKeyRoleRecipient((UserRole)role, userKey));
                }
                return roleRecipientBuilder.build();
            }
        });
    }

    protected Iterable<com.atlassian.confluence.mail.notification.Notification> permissionFiltered(List<com.atlassian.confluence.mail.notification.Notification> notifications, long id) {
        final ContentEntityObject entityObject = this.contentEntityManager.getById(id);
        return Iterables.filter(notifications, (Predicate)new Predicate<com.atlassian.confluence.mail.notification.Notification>(){

            public boolean apply(@Nullable com.atlassian.confluence.mail.notification.Notification input) {
                ConfluenceUser receiver = input.getReceiver();
                AccessStatus userAccessStatus = WatchTypeBasedRecipientProvider.this.confluenceAccessManager.getUserAccessStatus((User)receiver);
                return userAccessStatus.hasLicensedAccess() && WatchTypeBasedRecipientProvider.this.permissionManager.hasPermissionNoExemptions((User)receiver, Permission.VIEW, (Object)entityObject);
            }
        });
    }

    protected abstract Iterable<com.atlassian.confluence.mail.notification.Notification> computeNotifications(Notification<PAYLOAD> var1);
}

