/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.notifications.content;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ExperimentalApi
public class MessageIdUtil {
    private static final Pattern MESSAGE_ID_PATTERN = Pattern.compile("\\[(.*)]\\[(\\d+)]");

    public static String encodeMessageId(String completeKey, Content content) {
        return String.format("[%s][%s]", completeKey, content.getId().asLong());
    }

    public static Option<Pair<String, String>> extractFrom(String messageId) {
        if (messageId == null) {
            return Option.none();
        }
        Matcher matcher = MESSAGE_ID_PATTERN.matcher(messageId);
        if (matcher.matches()) {
            String notificationModuleKey = matcher.group(1);
            String contentId = matcher.group(2);
            return Option.some((Object)Pair.pair((Object)notificationModuleKey, (Object)contentId));
        }
        return Option.none();
    }
}

