AJS.toInit(function () {

    var cacheManagementBaseUrl = AJS.contextPath() + "/rest/cacheManagement/1.0/";

    function flushCache(flushArgs, successMessageArgs) {
        AJS.$.ajax({
            url: cacheManagementBaseUrl + 'cacheEntries',
            type: 'DELETE',
            data: flushArgs,
            success: function() {
                AJS.messages.success(successMessageArgs);
                refreshStats();
            },
            error: function() {
                AJS.messages.error({
                    body: AJS.I18n.getText("cacheManagement.flushCache.error.title"),
                    fadeout: true
                });
            }
        })
    }

    function openAdjustSizeDialog(cacheItem) {
        var dialog = AJS.dialog2(CacheManagement.AdjustmentDialog.dialog2({cache: cacheItem}));
        dialog.show();

        AJS.$("#adjustcache-cancel-button").click(function(e) {
            e.preventDefault();
            dialog.remove();
        });

        AJS.$("#adjustcache-submit-button").click(function(e) {
            e.preventDefault();
            submitCacheConfigChanges(cacheItem.name, dialog);
        });
    }

    function submitCacheConfigChanges(cacheName, dialog) {
        var maxElements = AJS.$("#maxElementsInCacheField input").val();
        if (!(maxElements > 0)) {
            AJS.$("#maxElementsInCacheField .error").removeClass("hidden");
            return;
        }
        AJS.$.ajax({
            type: "post",
            url: cacheManagementBaseUrl + "cacheConfig",
            data: {
                cacheName: cacheName,
                maxElements: Math.floor(maxElements)
            },
            headers: {
                "X-Atlassian-Token": "nocheck" // required for REST 2.8.0-m7. See XsrfResourceFilter.
            },
            success: function() {
                refreshStats();
                dialog.remove();
            }
        });
    }

    function registerCacheRowHandlers(cacheStatsRow) {
        var cacheItem = cacheStatsRow.data("cacheItem");

        cacheStatsRow.find("button.adjust-cache").click(function() {
            openAdjustSizeDialog(cacheItem);
        });

        cacheStatsRow.find("button.flush-cache").click(function() {
            flushCache(
                {
                    cacheName: cacheItem.name
                },
                {
                    title: AJS.I18n.getText("cacheManagement.flushCache.success.title"),
                    body: AJS.I18n.getText("cacheManagement.flushCache.success.body.namedCache") + " <strong>"+ cacheItem.niceName + "</strong>",
                    fadeout: true
                }
            );
        });
    }

    function registerFlushAllCachesHandler(container) {
        container.find("a.flush-all-caches").click(function() {
            flushCache(
                {},
                {
                    title: AJS.I18n.getText("cacheManagement.flushCache.success.title"),
                    body: AJS.I18n.getText("cacheManagement.flushCache.success.body.allCaches"),
                    fadeout: true
                }
            );
        });
    }

    var statsContainer = AJS.$("#cache-stats-container");
    var progressIndicator = AJS.$("#cache-stats-progress-indicator");

    function refreshStats() {
        progressIndicator.show();
        enableFullViewLink.addClass("hidden");

        var handleCacheStatsResponse = function (data) {
            var cacheStatsTable = AJS.$(CacheManagement.Statistics.Data.cacheStatisticsTable());

            var cacheStatsRowContainer = cacheStatsTable.find(".cache-stats-rows-container"),
                    cacheCount = data.length,
                    cacheItem = null;

            for (var i = 0; i < cacheCount; i++) {
                cacheItem = data[i];
                var cacheStatsRow = AJS.$(CacheManagement.Statistics.Data.cacheStatisticsTableRow({cache: cacheItem}));

                cacheStatsRow.data("cacheItem", cacheItem);

                registerCacheRowHandlers(cacheStatsRow);

                cacheStatsRowContainer.append(cacheStatsRow);
            }

            if (statsContainer.data("fullView") != true) {
                enableFullViewLink.removeClass("hidden");
                cacheStatsTable.find(".cache-stats-full-view").addClass("hidden");
            }
            progressIndicator.hide();
            statsContainer.html(cacheStatsTable);
            AJS.tablessortable.setTableSortable(cacheStatsTable);

            registerFlushAllCachesHandler(statsContainer);
        };

        var handleCacheStatsError = function (jqXHR, textStatus, errorThrown) {
            AJS.messages.error({
                title: AJS.I18n.getText("cacheManagement.stats.fetchError.title"),
                body: AJS.I18n.getText("cacheManagement.stats.fetchError.body")

            });
            progressIndicator.hide();
        };

        AJS.$.ajax({
            url: cacheManagementBaseUrl + "stats",
            success: handleCacheStatsResponse,
            error: handleCacheStatsError
        });
    }

    function enableFullView() {
        window.location.hash = "fullView";
        enableFullViewLink.addClass("hidden");
        AJS.$(".cache-stats-full-view").removeClass("hidden");
        statsContainer.data("fullView", true);
    }

    var enableFullViewLink = AJS.$("a.enable-cache-stats-full-view");
    enableFullViewLink.click(function(e) {
        e.preventDefault();
        enableFullView();
    });

    if (window.location.hash == '#fullView') {
        enableFullView();
    }

    refreshStats();
});