/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.cache.rest;

import com.atlassian.cache.CacheManager;
import com.atlassian.cache.ManagedCache;
import com.atlassian.confluence.cache.CacheStatistics;
import com.atlassian.confluence.cache.CacheStatisticsManager;
import com.atlassian.confluence.cache.model.CacheStatisticsEntity;
import com.atlassian.confluence.cache.rest.events.CacheManagementForbiddenEvent;
import com.atlassian.confluence.cache.rest.events.GetCacheStatisticsEvent;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.user.User;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/stats")
@Produces(value={"application/json"})
public class CacheStatisticsResource {
    private static final Logger log = LoggerFactory.getLogger(CacheStatisticsResource.class);
    private final PermissionManager permissionManager;
    private final CacheStatisticsManager cacheStatisticsManager;
    private final CacheManager cacheManager;
    private final ClusterManager clusterManager;
    private final EventPublisher eventPublisher;

    public CacheStatisticsResource(PermissionManager permissionManager, CacheStatisticsManager cacheStatisticsManager, CacheManager cacheManager, ClusterManager clusterManager, EventPublisher eventPublisher) {
        this.permissionManager = permissionManager;
        this.cacheStatisticsManager = cacheStatisticsManager;
        this.cacheManager = cacheManager;
        this.clusterManager = clusterManager;
        this.eventPublisher = eventPublisher;
    }

    @GET
    @Produces(value={"application/json"})
    public List<CacheStatisticsEntity> getCacheStatistics() throws IOException {
        if (this.isAdmin()) {
            long startTime = System.currentTimeMillis();
            List<CacheStatisticsEntity> response = this.buildResponseEntity();
            this.eventPublisher.publish((Object)new GetCacheStatisticsEvent(System.currentTimeMillis() - startTime));
            return response;
        }
        this.eventPublisher.publish((Object)new CacheManagementForbiddenEvent());
        throw new WebApplicationException(Response.Status.FORBIDDEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, ManagedCache> getManagedCaches() {
        long startTime = System.currentTimeMillis();
        try {
            ImmutableMap immutableMap = Maps.uniqueIndex((Iterable)this.cacheManager.getManagedCaches(), (Function)new Function<ManagedCache, String>(){

                public String apply(ManagedCache input) {
                    return input.getName();
                }
            });
            return immutableMap;
        }
        finally {
            log.debug("Fetching all managed caches took {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private List<CacheStatisticsEntity> buildResponseEntity() {
        ArrayList entities = Lists.newArrayList();
        Map<String, ManagedCache> managedCaches = this.getManagedCaches();
        for (CacheStatistics cacheStatistics : this.getSortedCacheStats()) {
            ManagedCache managedCache = managedCaches.get(cacheStatistics.getName());
            entities.add(new CacheStatisticsEntity(cacheStatistics, managedCache, this.clusterManager.isClustered()));
        }
        return entities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CacheStatistics> getSortedCacheStats() {
        long startTime = System.currentTimeMillis();
        try {
            ArrayList cacheStatsList = Lists.newArrayList((Iterable)this.cacheStatisticsManager.getLocalCacheStatistics());
            Collections.sort(cacheStatsList, new Comparator<CacheStatistics>(){

                @Override
                public int compare(CacheStatistics stats1, CacheStatistics stats2) {
                    return stats1.getNiceName().compareToIgnoreCase(stats2.getNiceName());
                }
            });
            ArrayList arrayList = cacheStatsList;
            return arrayList;
        }
        finally {
            log.debug("Fetching stats for all caches took {} ms", (Object)(System.currentTimeMillis() - startTime));
        }
    }

    private boolean isAdmin() {
        return this.permissionManager.isConfluenceAdministrator((User)AuthenticatedUserThreadLocal.get());
    }
}

