/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.sharelinksbookmarklet.actions;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.ConfluenceUser;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookmarkletAction
extends ConfluenceActionSupport
implements ServletRequestAware {
    private static final Logger log = LoggerFactory.getLogger(BookmarkletAction.class);
    private HttpServletRequest request;
    private SpaceManager spaceManager;
    private DarkFeaturesManager darkFeaturesManager;
    private List<Space> globalSpaces;
    private List<Space> favouriteSpaces;
    private Space personalSpace;
    private String loginURL;
    private String bookmarkedURL;

    public String execute() throws Exception {
        SpacesQuery globalSpacesListBuilder = SpacesQuery.newQuery().forUser(this.getRemoteUser()).withSpaceType(SpaceType.GLOBAL).withPermission("EDITSPACE").build();
        this.globalSpaces = this.spaceManager.getAllSpaces(globalSpacesListBuilder);
        ConfluenceUser authenticatedUser = this.getAuthenticatedUser();
        if (authenticatedUser != null) {
            this.personalSpace = this.spaceManager.getPersonalSpace(authenticatedUser.getName());
        }
        this.favouriteSpaces = this.computeFavouriteSpaces(this.globalSpaces);
        this.globalSpaces.removeAll(this.favouriteSpaces);
        this.loginURL = this.computeLoginURL();
        return "success";
    }

    public List<Space> getAvailableGlobalSpaces() {
        return this.globalSpaces;
    }

    public String getPersonalSpaceKey() {
        return this.personalSpace != null ? this.personalSpace.getKey() : null;
    }

    public String getLoginURL() {
        return this.loginURL;
    }

    private String computeLoginURL() throws UnsupportedEncodingException {
        String contextPath = this.request.getContextPath();
        String currentURLWithoutContextPath = this.request.getRequestURI().substring(contextPath.length());
        if (this.request.getQueryString() != null) {
            currentURLWithoutContextPath = currentURLWithoutContextPath + "?" + this.request.getQueryString();
        }
        return contextPath + "/login.action?os_destination=" + URLEncoder.encode(currentURLWithoutContextPath, "UTF-8");
    }

    private List<Space> computeFavouriteSpaces(List<Space> permittedGlobalSpaces) {
        if (this.getRemoteUser() == null) {
            return Collections.emptyList();
        }
        List favouriteSpaces = this.labelManager.getFavouriteSpaces(this.getRemoteUser().getName());
        if (this.personalSpace != null) {
            favouriteSpaces.remove(this.personalSpace);
        }
        if (permittedGlobalSpaces.isEmpty()) {
            Iterator spaceIterator = favouriteSpaces.iterator();
            while (spaceIterator.hasNext()) {
                Space space = (Space)spaceIterator.next();
                if (this.permissionManager.hasCreatePermission(this.getRemoteUser(), (Object)space, Page.class)) continue;
                spaceIterator.remove();
            }
        } else {
            favouriteSpaces.retainAll(permittedGlobalSpaces);
        }
        return favouriteSpaces;
    }

    public List<Space> getFavouriteSpaces() {
        return this.favouriteSpaces;
    }

    public void setServletRequest(HttpServletRequest request) {
        this.request = request;
    }

    public String getBookmarkedURL() {
        return this.bookmarkedURL;
    }

    public void setBookmarkedURL(String bookmarkedURL) {
        this.bookmarkedURL = bookmarkedURL;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setDarkFeaturesManager(DarkFeaturesManager darkFeaturesManager) {
        this.darkFeaturesManager = darkFeaturesManager;
    }
}

