/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.sharelinks.metaextractor;

import com.atlassian.confluence.plugins.sharelinks.DOMMetadataExtractor;
import com.atlassian.confluence.plugins.sharelinks.LinkMetaData;
import com.atlassian.confluence.plugins.sharelinks.metaextractor.JsoupUtil;
import com.atlassian.confluence.util.http.HttpRequest;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDOMMetadataExtractor
implements DOMMetadataExtractor {
    private static final Logger log = LoggerFactory.getLogger(SimpleDOMMetadataExtractor.class);
    private static final String TITLE_QUERY = "title";
    private static final String META_TITLE_QUERY = "meta[name=title]";
    private static final String META_DESCRIPTION_QUERY = "meta[name=description]";
    private static final String FAVICON_QUERY = "link[rel=shortcut icon]";
    private final HttpRetrievalService httpRetrievalService;

    public SimpleDOMMetadataExtractor(HttpRetrievalService httpRetrievalService) {
        this.httpRetrievalService = httpRetrievalService;
    }

    @Override
    public void updateMetadata(LinkMetaData meta, Document head) {
        if (StringUtils.isBlank((String)meta.getTitle())) {
            Elements titleElements;
            String title = JsoupUtil.getMetaContent(head, META_TITLE_QUERY);
            if (title == null && !(titleElements = head.select(TITLE_QUERY)).isEmpty()) {
                title = titleElements.text();
            }
            meta.setTitle(title);
        }
        if (StringUtils.isBlank((String)meta.getDescription())) {
            meta.setDescription(JsoupUtil.getMetaContent(head, META_DESCRIPTION_QUERY));
        }
        if (StringUtils.isBlank((String)meta.getFaviconURL())) {
            Elements faviconElements = head.select(FAVICON_QUERY);
            if (!faviconElements.isEmpty() && ((Element)faviconElements.get(0)).attr("href") != null) {
                String faviconURL = ((Element)faviconElements.get(0)).attr("href");
                faviconURL = this.getAbsolutePath(faviconURL, meta.getResponseHost());
                meta.setFaviconURL(faviconURL);
            } else {
                this.retrieveWebRootFavicon(meta);
            }
        }
    }

    private void retrieveWebRootFavicon(LinkMetaData meta) {
        if (meta.getFaviconURL() == null) {
            URI webRootFavicon = SimpleDOMMetadataExtractor.getFaviconUri(meta.getResponseHost());
            String webRootFaviconPath = webRootFavicon.toString();
            HttpRequest request = this.httpRetrievalService.getDefaultRequestFor(webRootFaviconPath);
            try {
                HttpResponse response = this.httpRetrievalService.get(request);
                if (response.getStatusCode() == 200) {
                    meta.setFaviconURL(webRootFaviconPath);
                }
            }
            catch (IOException e) {
                log.error("Error with io exception: ", (Throwable)e);
            }
        }
    }

    private String getAbsolutePath(String path, URI host) {
        try {
            URI uri = host.resolve(path.trim());
            return uri.toString();
        }
        catch (IllegalArgumentException e) {
            log.info("Favicon path {} could not be resolved.", (Object)path);
            return null;
        }
    }

    protected static URI getFaviconUri(URI uri) {
        return uri.resolve("/favicon.ico");
    }
}

