/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.sharelinks.metaextractor;

import com.atlassian.confluence.plugins.sharelinks.DOMMetadataExtractor;
import com.atlassian.confluence.plugins.sharelinks.LinkMetaData;
import com.atlassian.confluence.plugins.sharelinks.LinkMetaDataExtractor;
import com.atlassian.confluence.plugins.sharelinks.metaextractor.OpenGraphDOMMetadataExtractor;
import com.atlassian.confluence.plugins.sharelinks.metaextractor.SimpleDOMMetadataExtractor;
import com.atlassian.confluence.plugins.sharelinks.metaextractor.TwitterDOMMetadataExtractor;
import com.atlassian.confluence.util.http.HttpRequest;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.confluence.util.http.HttpRetrievalService;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

public class MasterLinkMetaDataExtractor
implements LinkMetaDataExtractor {
    private static final Pattern UNTIL_END_HEAD_OR_EOF_PATTERN = Pattern.compile(".*?</head>|.*", 34);
    private static final int MAX_HEAD_SIZE = 131072;
    private static final int DESCRIPTION_MAX_LENGTH = 180;
    private static final int DOMAIN_MAX_LENGTH = 50;
    private static final int EXCERPT_URL_MAX_LENGTH = 30;
    private static final Logger log = Logger.getLogger(MasterLinkMetaDataExtractor.class);
    private final List<DOMMetadataExtractor> metadataExtractors;
    private final HttpRetrievalService httpRetrievalService;

    public MasterLinkMetaDataExtractor(HttpRetrievalService httpRetrievalService) {
        this.httpRetrievalService = httpRetrievalService;
        this.metadataExtractors = ImmutableList.of((Object)new OpenGraphDOMMetadataExtractor(), (Object)new TwitterDOMMetadataExtractor(), (Object)new SimpleDOMMetadataExtractor(httpRetrievalService));
    }

    @Override
    public LinkMetaData parseMetaData(String url, boolean isPreview) throws URISyntaxException {
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            url = "http://" + url;
        }
        LinkMetaData meta = new LinkMetaData(url);
        meta.setExcerptedURL(this.getExcerptedUrl(url));
        URI uri = new URI(url);
        String domain = StringUtils.isBlank((String)uri.getHost()) ? url : uri.getHost();
        meta.setDomain(MasterLinkMetaDataExtractor.getPreviewText(domain, 50));
        String htmlData = this.getHeadHtmlData(url, meta);
        Document jsoupDoc = Jsoup.parse((String)htmlData);
        if (!htmlData.isEmpty()) {
            for (DOMMetadataExtractor metadataExtractor : this.metadataExtractors) {
                metadataExtractor.updateMetadata(meta, jsoupDoc);
            }
        }
        if (isPreview) {
            meta.setDescription(MasterLinkMetaDataExtractor.getPreviewText(meta.getDescription(), 180));
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHeadHtmlData(String url, LinkMetaData meta) {
        InputStream inputStream = null;
        try {
            HttpRequest request = this.httpRetrievalService.getDefaultRequestFor(url);
            request.setHeader("accept-charset", "utf-8");
            HttpResponse response = this.httpRetrievalService.get(request);
            meta.setResponseHost(this.getResponseURI(response, url));
            if (!this.isValidResponse(response)) {
                String string = "";
                return string;
            }
            inputStream = response.getResponse();
            String charset = response.getCharset();
            if (charset == null) {
                HeaderElement[] contents;
                inputStream.mark(Integer.MAX_VALUE);
                Scanner bodyScanner = new Scanner(inputStream, "UTF-8");
                String attempt = bodyScanner.findWithinHorizon(UNTIL_END_HEAD_OR_EOF_PATTERN, 131072);
                Document jsoupDoc = Jsoup.parse((String)attempt);
                String contentType = jsoupDoc.select("meta[http-equiv=Content-Type][content]").attr("content");
                for (HeaderElement headerElement : contents = HeaderElement.parseElements((String)contentType)) {
                    NameValuePair charsetparam = headerElement.getParameterByName("charset");
                    if (charsetparam == null) continue;
                    charset = charsetparam.getValue();
                    break;
                }
                inputStream.reset();
            }
            meta.setCharset(charset == null ? "UTF-8" : charset);
            Scanner responseScanner = new Scanner(inputStream, meta.getCharset());
            String string = responseScanner.findWithinHorizon(UNTIL_END_HEAD_OR_EOF_PATTERN, 131072);
            IOUtils.closeQuietly((InputStream)inputStream);
            return string;
        }
        catch (IOException e) {
            log.error((Object)"Error with io exception: ", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"Error in parse data: ", (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
        return "";
    }

    private URI getResponseURI(HttpResponse response, String url) throws URISyntaxException {
        URI responseURI = response.getResponseURI();
        if (responseURI.getHost() == null) {
            responseURI = new URI(url);
        }
        return responseURI;
    }

    private static String getPreviewText(String text, int maxLength) {
        if (text == null || text.length() <= maxLength) {
            return text;
        }
        int lastSpaceIndex = (text = text.substring(0, maxLength)).lastIndexOf(32);
        if (lastSpaceIndex != -1) {
            text = text.substring(0, lastSpaceIndex);
        }
        int ELLIPSIS = 8230;
        return text + '\u2026';
    }

    private String getExcerptedUrl(String sourceUrl) {
        String excerptedUrl = sourceUrl;
        String split = "//";
        int splitIndex = excerptedUrl.indexOf(split);
        if ((excerptedUrl = excerptedUrl.substring(splitIndex + split.length())).length() > 30) {
            excerptedUrl = excerptedUrl.substring(0, 29);
            excerptedUrl = excerptedUrl + '\u2026';
        }
        return excerptedUrl;
    }

    private boolean isValidResponse(HttpResponse response) {
        int statusCode = response.getStatusCode();
        String mimeType = response.getMIMEType();
        return statusCode >= 200 && statusCode < 300 && (mimeType == null || mimeType.startsWith("text/"));
    }
}

