/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.sharelinks.listener;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.pages.CommentManager;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.api.events.BlueprintPageCreateEvent;
import com.atlassian.confluence.plugins.sharepage.api.SharePageService;
import com.atlassian.confluence.plugins.sharepage.api.ShareRequest;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class SharelinksBlueprintListener
implements DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SharelinksBlueprintListener.class);
    private static final ModuleCompleteKey SHARELINKS_BLUEPRINT_KEY = new ModuleCompleteKey("com.atlassian.confluence.plugins.confluence-business-blueprints", "sharelinks-blueprint");
    private final CommentManager commentManager;
    private final EventPublisher evenPublisher;
    private final SharePageService sharePageService;
    private final PermissionManager permissionManager;
    private final LabelManager labelManager;
    private final UserAccessor userAccessor;

    public SharelinksBlueprintListener(EventPublisher eventPublisher, CommentManager commentManager, SharePageService sharePageService, LabelManager labelManager, PermissionManager permissionManager, UserAccessor userAccessor) {
        this.evenPublisher = eventPublisher;
        this.commentManager = commentManager;
        this.sharePageService = sharePageService;
        this.labelManager = labelManager;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
        eventPublisher.register((Object)this);
    }

    @EventListener
    public void onBlueprintCreateEvent(BlueprintPageCreateEvent event) {
        ModuleCompleteKey moduleCompleteKey = event.getBlueprintKey();
        if (!SHARELINKS_BLUEPRINT_KEY.equals((Object)moduleCompleteKey)) {
            return;
        }
        Page blueprintPage = event.getPage();
        Map context = event.getContext();
        String comment = (String)context.get("comment");
        String shareWith = (String)context.get("sharewith");
        String label = (String)context.get("label");
        if (logger.isDebugEnabled()) {
            logger.debug("Event caught with context {}", (Object)event.getContext());
        }
        if (this.permissionManager.hasCreatePermission(this.getUser(), (Object)event.getPage().getSpace(), Comment.class)) {
            this.addCommentIfNotBlank(blueprintPage, comment);
        }
        this.addLabelIfNotBlank((Labelable)blueprintPage, label);
        this.shareWithUsers(blueprintPage, shareWith, comment);
    }

    private User getUser() {
        return AuthenticatedUserThreadLocal.getUser();
    }

    private void addCommentIfNotBlank(Page blueprintPage, String comment) {
        if (StringUtils.isNotBlank((CharSequence)comment)) {
            comment = GeneralUtil.plain2html((String)comment);
            this.commentManager.addCommentToObject((ContentEntityObject)blueprintPage, null, comment);
        }
    }

    private void addLabelIfNotBlank(Labelable blueprintPage, String label) {
        if (StringUtils.isNotBlank((CharSequence)label)) {
            HashSet<String> labels = new HashSet<String>();
            labels.addAll(Arrays.asList(label.split(",")));
            for (String labelValue : labels) {
                Label newLabel = new Label(labelValue);
                this.labelManager.addLabel(blueprintPage, newLabel);
            }
        }
    }

    private void shareWithUsers(Page page, String sharewith, String note) {
        if (StringUtils.isNotBlank((CharSequence)sharewith)) {
            HashSet<String> usersToShare = new HashSet<String>();
            usersToShare.addAll(this.getUserKeys(Arrays.asList(sharewith.split(","))));
            ShareRequest shareContent = new ShareRequest();
            shareContent.setEntityId(Long.valueOf(page.getId()));
            shareContent.setEntityType(ShareRequest.EntityType.PAGE.getValue());
            shareContent.setUsers(usersToShare);
            shareContent.setNote(note);
            shareContent.setEmails(Collections.emptySet());
            this.sharePageService.share(shareContent);
        }
    }

    private List<String> getUserKeys(List<String> listUsername) {
        ArrayList<String> listUserkey = new ArrayList<String>();
        for (String username : listUsername) {
            ConfluenceUser user = this.userAccessor.getUserByName(username);
            if (null == user) continue;
            listUserkey.add(user.getKey().getStringValue());
        }
        return listUserkey;
    }

    public void destroy() throws Exception {
        this.evenPublisher.unregister((Object)this);
    }
}

