/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.sharelinks;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.DefaultImagePlaceholder;
import com.atlassian.confluence.macro.EditorImagePlaceholder;
import com.atlassian.confluence.macro.ImagePlaceholder;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.thumbnail.Dimensions;
import com.atlassian.confluence.plugins.BusinessBlueprintsContextProviderHelper;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class URLMacro
implements Macro,
EditorImagePlaceholder {
    private final SettingsManager settingsManager;
    private final BusinessBlueprintsContextProviderHelper helper;
    private static final String IMAGE_PATH = "/download/resources/com.atlassian.confluence.plugins.confluence-business-blueprints:sharelinks-urlmacro-editor-resources/sharelinks-urlmacro-placeholder.png";

    public URLMacro(SettingsManager settingsManager, BusinessBlueprintsContextProviderHelper helper) {
        this.settingsManager = settingsManager;
        this.helper = helper;
    }

    public String execute(Map<String, String> parameters, String bodyText, ConversionContext conversionContext) throws MacroExecutionException {
        String soyBookmarkletLinkTemplateName = "Confluence.Blueprints.SharelinksUrlMacro.bookmarkletLink.soy";
        String bookmarkletActionURL = this.settingsManager.getGlobalSettings().getBaseUrl() + "/plugins/sharelinksbookmarklet/bookmarklet.action";
        HashMap soyLinkMetaDataContext = Maps.newHashMap();
        soyLinkMetaDataContext.put("bookmarkletActionURL", bookmarkletActionURL);
        String soyBookmarkletGuideHtml = this.helper.renderFromSoy("com.atlassian.confluence.plugins.confluence-business-blueprints:sharelinks-urlmacro-resources", soyBookmarkletLinkTemplateName, soyLinkMetaDataContext);
        return soyBookmarkletGuideHtml;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public ImagePlaceholder getImagePlaceholder(Map<String, String> params, ConversionContext ctx) {
        return new DefaultImagePlaceholder(IMAGE_PATH, new Dimensions(175, 30), false);
    }
}

