/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.sharelinks;

import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.sharelinks.LinkMetaData;
import com.atlassian.confluence.plugins.sharelinks.LinkMetaDataExtractor;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.user.User;
import java.net.URISyntaxException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Path(value="/")
public class SharelinksResource {
    private final LinkMetaDataExtractor linkMetaDataExtractor;
    private final PermissionManager permissionManager;
    private static final Response.Status BAD_REQUEST = Response.Status.BAD_REQUEST;
    private final SpaceManager spaceManager;

    public SharelinksResource(LinkMetaDataExtractor linkMetaDataExtractor, PermissionManager permissionManager, SpaceManager spaceManager) {
        this.linkMetaDataExtractor = linkMetaDataExtractor;
        this.permissionManager = permissionManager;
        this.spaceManager = spaceManager;
    }

    @GET
    @Path(value="link")
    @Produces(value={"application/json"})
    public Response getLinkMetaData(@QueryParam(value="url") String url) {
        try {
            LinkMetaData link = this.linkMetaDataExtractor.parseMetaData(url, true);
            return Response.ok((Object)link).build();
        }
        catch (URISyntaxException e) {
            return Response.status((Response.Status)BAD_REQUEST).entity((Object)"The provided URL is invalid").build();
        }
    }

    @GET
    @Path(value="can-create-comment")
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response canCreateComment(@QueryParam(value="spaceKey") String spaceKey) {
        Space space = this.spaceManager.getSpace(spaceKey);
        if (space == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"No space found for spacekey").build();
        }
        boolean canCreate = this.permissionManager.hasCreatePermission(this.getUser(), (Object)space, Comment.class);
        return Response.ok((Object)canCreate).build();
    }

    private User getUser() {
        return AuthenticatedUserThreadLocal.getUser();
    }
}

