define('confluence-browser-metrics/marshallers/server-duration-marshaller', [
    'confluence-browser-metrics/util/is-number'
], function (
    isNumber
) {
    function isServerDurationReport(report) {
        return isNumber(report.serverDuration);
    }

    var serverDurationMarshaller = function (report) {
        if (isServerDurationReport(report)) {
            return { serverDuration: "" + Math.floor(report.serverDuration) };
        }
    };

    return serverDurationMarshaller;

});