/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.attachments.rest;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.extra.attachments.ImagePreviewRenderer;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.renderer.RenderContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

@Path(value="details")
public class DetailsResource {
    private final AttachmentManager attachmentManager;
    private final ImagePreviewRenderer imagePreviewRenderer;

    public DetailsResource(AttachmentManager attachmentManager, ImagePreviewRenderer imagePreviewRenderer) {
        this.attachmentManager = attachmentManager;
        this.imagePreviewRenderer = imagePreviewRenderer;
    }

    @Produces(value={"text/html"})
    @GET
    @Path(value="preview")
    public String getPreview(@QueryParam(value="attachmentId") long attachmentId) {
        Attachment attachment = this.attachmentManager.getAttachment(attachmentId);
        if (attachment != null) {
            try {
                return this.getAttachmentPreviewHtml(attachment);
            }
            catch (XhtmlException e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    private String getAttachmentPreviewHtml(Attachment attachment) throws XhtmlException {
        return this.imagePreviewRenderer.render(attachment, (ConversionContext)new DefaultConversionContext((RenderContext)attachment.getContainer().toPageContext()));
    }
}

