/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.extra.attachments;

import com.atlassian.bonnie.Handle;
import com.atlassian.confluence.core.persistence.AnyTypeDao;
import com.atlassian.confluence.extra.attachments.SpaceAttachments;
import com.atlassian.confluence.extra.attachments.SpaceAttachmentsUtils;
import com.atlassian.confluence.macro.query.BooleanQueryFactory;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.ResultFilter;
import com.atlassian.confluence.search.v2.SearchFilter;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResult;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.filter.SubsetResultFilter;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.FileExtensionQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.LabelQuery;
import com.atlassian.confluence.search.v2.searchfilter.ContentPermissionsSearchFilter;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.search.v2.sort.ModifiedSort;
import com.atlassian.confluence.search.v2.sort.RelevanceSort;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSpaceAttachmentsUtils
implements SpaceAttachmentsUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSpaceAttachmentsUtils.class);
    private final SearchManager searchManager;
    private final AnyTypeDao anyTypeDao;
    private int totalAttachments;
    private int totalPage;

    public DefaultSpaceAttachmentsUtils(SearchManager searchManager, AnyTypeDao anyTypeDao) {
        this.searchManager = searchManager;
        this.anyTypeDao = anyTypeDao;
    }

    @Override
    public SpaceAttachments getAttachmentList(String spaceKey, int pageNumber, int previousTotalAttachments, int pageSize, String sortBy, String fileExtension, Set<String> labels) throws InvalidSearchException {
        SpaceAttachments spaceAttachments = new SpaceAttachments();
        BooleanQueryFactory query = new BooleanQueryFactory();
        query.addMust((SearchQuery)new ContentTypeQuery(ContentTypeEnum.ATTACHMENT));
        query.addMust((SearchQuery)new InSpaceQuery(spaceKey));
        if (StringUtils.isNotBlank((String)fileExtension)) {
            query.addMust((SearchQuery)new FileExtensionQuery(fileExtension));
        }
        if (labels != null && !labels.isEmpty()) {
            for (String label : labels) {
                query.addMust((SearchQuery)new LabelQuery(label.trim()));
            }
        }
        RelevanceSort searchSort = new RelevanceSort();
        if ("name".equalsIgnoreCase(sortBy)) {
            searchSort = new TitleSort(SearchSort.Order.ASCENDING);
        } else if ("date".equalsIgnoreCase(sortBy)) {
            searchSort = new ModifiedSort(SearchSort.Order.DESCENDING);
        } else if ("createddate".equalsIgnoreCase(sortBy)) {
            searchSort = new CreatedSort(SearchSort.Order.DESCENDING);
        }
        int startIndex = 0;
        if (pageSize == 0) {
            pageSize = 20;
        }
        if (previousTotalAttachments > 0) {
            startIndex = this.calculateStartIndex(pageNumber, pageSize);
        }
        ContentSearch search = new ContentSearch((SearchQuery)query.toBooleanQuery(), (SearchSort)searchSort, (SearchFilter)ContentPermissionsSearchFilter.getInstance(), (ResultFilter)new SubsetResultFilter(startIndex, pageSize));
        ArrayList<Attachment> attachmentList = new ArrayList<Attachment>();
        try {
            SearchResults searchResults = this.searchManager.search((ISearch)search);
            this.totalAttachments = searchResults.getUnfilteredResultsCount();
            this.totalPage = this.calculateTotalPage(this.totalAttachments, pageSize);
            Iterator i = searchResults.iterator();
            while (i.hasNext()) {
                Handle handle = ((SearchResult)i.next()).getHandle();
                Attachment attachment = (Attachment)this.anyTypeDao.findByHandle(handle);
                attachmentList.add(attachment);
            }
            spaceAttachments.setAttachmentList(attachmentList);
            spaceAttachments.setTotalAttachments(this.totalAttachments);
            spaceAttachments.setTotalPage(this.totalPage);
        }
        catch (InvalidSearchException e) {
            LOG.error("Invalid search exception ", (Throwable)e);
            throw new InvalidSearchException(e.getMessage());
        }
        return spaceAttachments;
    }

    protected int calculateTotalPage(int totalAttachments, int pageSize) {
        double dPageTotal = Math.ceil((double)totalAttachments / (double)pageSize);
        return (int)dPageTotal;
    }

    protected int calculateStartIndex(int pageNumber, int pageSize) {
        return Math.max(0, (pageNumber - 1) * pageSize);
    }
}

