define('acm/app/views/runtime-info-supplier-view', [
    'acm/app/models/data-supplier-model',
    'backbone',
    'eventbus'
],
function (
    DataSupplierModel,
    Backbone,
    Eventbus
) {
    'use strict';

    var RuntimeInfoSupplierView = Backbone.View.extend(
        {
            initialize: function () {
                this.listenTo(Eventbus, 'node-collection:rendered', this.render);
            },

            render: function (data) {
                var that = this;

                data.nodes.forEach(function (node) {
                    var nodeId = node.get('nodeId');
                    var row = that.$el.find('.' + nodeId);
                    var runtimeModel = new DataSupplierModel({
                        pluginKey: 'com.atlassian.cluster.monitoring.cluster-monitoring-plugin',
                        moduleKey: 'runtime-information',
                        nodeId: nodeId
                    });

                    runtimeModel.fetch({
                        success: function (model) {
                            var rowData = model.toJSON().data.rows;
                            row.find('.load').text(rowData.percentLoad[1]);
                            row.find('.memory').text(rowData.percentHeap[1]);
                            row.find('.uptime').text(rowData.uptime[1]);
                        }
                    });
                });
            }
        }
    );

    return RuntimeInfoSupplierView;
});
