define('acm/app/views/node-current-highlighter-view', [
    'acm/app/models/node-current-model',
    'ajs',
    'backbone',
    'eventbus'
],
function (
    NodeCurrentModel,
    AJS,
    Backbone,
    Eventbus
) {
    'use strict';

    var NodeCurrentHighlighterView = Backbone.View.extend(
        {
            model: new NodeCurrentModel(),

            initialize: function () {
                this.listenTo(Eventbus, 'node-collection:rendered', this.fetchModel);
                this.listenTo(this.model, 'sync', this.render);
            },

            fetchModel: function (data) {
                this.model.fetch();
            },

            render: function () {
                var currentNodeRow = this.$el.find('.' + this.model.get('nodeId'));

                currentNodeRow.addClass('node-current');

                //the icon is full of whitespace. this brings the tooltip anchor in by 1/4 the height of the icon
                var currentNodeStatusCell = currentNodeRow.find('.status');
                currentNodeStatusCell.attr('title', AJS.I18n.getText('application.web.config.clustering.node.status.current.tooltip'));
                currentNodeStatusCell.tooltip({ gravity: 's', offset: (currentNodeStatusCell.height() / -4) });
            }
        }
    );

    return NodeCurrentHighlighterView;
});

