define('acm/app/views/data-supplier-dropdown-view', [
    'acm/app/models/data-supplier-collection',
    'backbone',
    'eventbus'
],
function (
    DataSupplierCollection,
    Backbone,
    Eventbus
) {
    'use strict';

    var DataSupplierDropDownView = Backbone.View.extend(
        {
            collection: new DataSupplierCollection(),
            template: Cluster.Monitoring.Templates.suppliersDropdown,

            initialize: function () {
                this.listenTo(Eventbus, 'node-collection:rendered', this.render);
            },

            render: function (data) {
                var that = this;
                var container = this.$el;

                this.collection.fetch({
                    success: function (suppliers) {
                        data.nodes.forEach(
                            function (node) {
                                var nodeId = node.get('nodeId');
                                var row = container.find('.' + nodeId);
                                that.renderRow(row, nodeId, suppliers);
                            }
                        );
                    }
                });
            },

            renderRow: function (el, nodeId, suppliers) {
                var dataSuppliersDropDown = el.find('.data-suppliers');

                var template = this.template({
                    nodeId: nodeId,
                    suppliers: suppliers.toJSON()
                });

                dataSuppliersDropDown.html(template);
            }
        }
    );

    return DataSupplierDropDownView;
});