define('acm/app/views/clustering-view', [
    'acm/app/models/node-collection',
    'acm/app/models/data-supplier-model',
    'acm/app/views/node-collection-view',
    'acm/app/views/data-supplier-view',
    'acm/app/views/error-handling-view',
    'ajs',
    'backbone',
    'jquery',
    'underscore',
    'exports'
],
function (
    NodeCollection,
    DataSupplierModel,
    NodeCollectionView,
    DataSupplierView,
    ErrorHandingView,
    AJS,
    Backbone,
    $,
    _,
    exports
) {
    'use strict';

    function onReady() {
        AJS.trigger('analyticsEvent', {name: 'clusteringView.rendered'});

        var AppRouter = Backbone.Router.extend(
            {
                errorHandingView: new ErrorHandingView(),
                nodeCollectionView: new NodeCollectionView(),

                routes: {
                    '': 'home',
                    'providers/:pluginKey/:moduleKey/:nodeId': 'supplierView'
                },

                home: function () {
                    this.nodeCollectionView.collection.fetch();
                },

                supplierView: function (pluginKey, moduleKey, nodeId) {
                    var supplierModel = new DataSupplierModel({
                        pluginKey: pluginKey,
                        moduleKey: moduleKey,
                        nodeId: nodeId
                    });

                    var supplierView = new DataSupplierView({model: supplierModel});

                    supplierView.model.fetch();
                }
            }
        );

        var appRouter = new AppRouter();

        Backbone.history.start();
    }

    exports.onReady = onReady;
});