define('acm/app/models/node-collection', [
    'ajs',
    'backbone',
    'eventbus'
],
function (
    AJS,
    Backbone,
    Eventbus
) {
    'use strict';

    return Backbone.Collection.extend (
        {
            initialize: function (options) {
                this.bind('error', function(model, error){
                    Eventbus.trigger('acm:monitoring-error', error);
                });
            },

            url: AJS.contextPath () + '/rest/atlassian-cluster-monitoring/cluster/nodes'
        }
    );
});
