define('csvgenerator', [
        'underscore',
        'exports'
    ],
    function (_,
        exports) {
        'use strict';

        // Simple & simplistic csv exporter.
        // Uses \t as column separator.
        // Doesn't handle \t and \n inside content.
        var generate = function generate (headers, data) {
            var createRow = function (hash) {
                return _.map(hash, function (val, key) {
                    return '"' + val + '"';
                }).join('\t');
            };

            var headersContent = createRow(headers);

            var dataContent = _.map(data, function (list, key) {
                return createRow(list);
            });

            return ['sep=\t', headersContent].concat(dataContent).join('\r\n');
        };

        exports.generate = generate;
    });