/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cluster.monitoring.servlet;

import com.atlassian.cluster.monitoring.spi.ClusterMonitoring;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClusterMonitoringServlet
extends HttpServlet {
    private final UserManager userManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final ClusterMonitoring clusterMonitoring;

    public ClusterMonitoringServlet(UserManager userManager, SoyTemplateRenderer soyTemplateRenderer, ClusterMonitoring clusterMonitoring) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.soyTemplateRenderer = (SoyTemplateRenderer)Preconditions.checkNotNull((Object)soyTemplateRenderer);
        this.clusterMonitoring = (ClusterMonitoring)Preconditions.checkNotNull((Object)clusterMonitoring);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserKey userKey = this.userManager.getRemoteUserKey(req);
        if (userKey != null && this.userManager.isSystemAdmin(userKey)) {
            resp.setContentType("text/html; charset=UTF-8");
            try {
                ImmutableMap context = ImmutableMap.of((Object)"clusteringAvailable", (Object)this.clusterMonitoring.isAvailable());
                this.soyTemplateRenderer.render((Appendable)resp.getWriter(), "com.atlassian.cluster.monitoring.cluster-monitoring-plugin:bootstrap-resource", "Cluster.Monitoring.Templates.bootstrap", (Map)context);
            }
            catch (SoyException se) {
                throw new RuntimeException(se);
            }
        } else {
            resp.sendError(403, "Only a system administrator can access this resource");
        }
    }
}

