/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cluster.monitoring.rest;

import com.atlassian.cluster.monitoring.descriptor.MonitoringDataSupplierModuleDescriptor;
import com.atlassian.cluster.monitoring.rest.DataSupplier;
import com.atlassian.cluster.monitoring.spi.ClusterMonitoring;
import com.atlassian.cluster.monitoring.spi.model.NodeIdentifier;
import com.atlassian.fugue.Either;
import com.atlassian.plugin.ModuleCompleteKey;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.rest.common.security.jersey.SysadminOnlyResourceFilter;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.container.ResourceFilters;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="cluster")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ResourceFilters(value={SysadminOnlyResourceFilter.class})
public class ClusterMonitoringResource {
    private static final Logger log = LoggerFactory.getLogger(ClusterMonitoringResource.class);
    private static final String SERVER_ERROR_MESSAGE = "com.atlassian.monitoring.error";
    private final ClusterMonitoring clusterMonitoring;
    private final PluginAccessor pluginAccessor;
    private final I18nResolver i18nResolver;

    public ClusterMonitoringResource(ClusterMonitoring clusterMonitoring, PluginAccessor pluginAccessor, I18nResolver i18nResolver) {
        this.clusterMonitoring = (ClusterMonitoring)Preconditions.checkNotNull((Object)clusterMonitoring);
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor);
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver);
    }

    @GET
    @Path(value="nodes")
    public Response getNodes() {
        return ClusterMonitoringResource.convertEitherToResponse(this.clusterMonitoring.getNodes());
    }

    @GET
    @Path(value="current-node")
    public Response getCurrentNode() {
        return ClusterMonitoringResource.convertEitherToResponse(this.clusterMonitoring.getCurrentNode());
    }

    @GET
    @Path(value="suppliers")
    public Collection<DataSupplier> getDataSuppliers() {
        return Collections2.transform(this.monitoringModuleDescriptors(), this.asDataSupplier());
    }

    @GET
    @Path(value="suppliers/data/{pluginKey}/{moduleKey}/{nodeId}")
    public Response getDataProviderInformationForNode(@PathParam(value="pluginKey") String pluginKey, @PathParam(value="moduleKey") String moduleKey, @PathParam(value="nodeId") NodeIdentifier nodeId) {
        ModuleCompleteKey key = new ModuleCompleteKey(pluginKey, moduleKey);
        Either eitherData = this.clusterMonitoring.getData(key, nodeId);
        if (eitherData.isLeft()) {
            log.warn("Error received when querying remote node [{}]: ", (Object)nodeId, eitherData.left().get());
            String notScaryError = this.i18nResolver.getText(SERVER_ERROR_MESSAGE, new Serializable[]{nodeId});
            return Response.serverError().entity((Object)notScaryError).build();
        }
        MonitoringDataSupplierModuleDescriptor moduleDescriptor = (MonitoringDataSupplierModuleDescriptor)this.pluginAccessor.getEnabledPluginModule(key.getCompleteKey());
        DataSupplier dataSupplier = (DataSupplier)this.asDataSupplier().apply((Object)moduleDescriptor);
        return Response.ok((Object)ImmutableMap.of((Object)"supplier", (Object)dataSupplier, (Object)"data", (Object)eitherData.right().get())).build();
    }

    private List<MonitoringDataSupplierModuleDescriptor> monitoringModuleDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(MonitoringDataSupplierModuleDescriptor.class);
    }

    private Function<MonitoringDataSupplierModuleDescriptor, DataSupplier> asDataSupplier() {
        return new Function<MonitoringDataSupplierModuleDescriptor, DataSupplier>(){

            public DataSupplier apply(MonitoringDataSupplierModuleDescriptor descriptor) {
                String i18nKey = descriptor.getI18nNameKey();
                String i18nLabel = ClusterMonitoringResource.this.i18nResolver.getText(i18nKey);
                return new DataSupplier(new ModuleCompleteKey(descriptor.getCompleteKey()), i18nKey, i18nLabel);
            }
        };
    }

    static Response convertEitherToResponse(Either either) {
        return either.isLeft() ? Response.serverError().entity(either.left().get()).build() : Response.ok((Object)either.right().get()).build();
    }
}

