;(function() {
var util_window, is_supported, event_stream, api_addReporter, api_delegateTo, api_end, util_matches_selector, util_multi_value_map, util_document, util_element_hound, util_element_wolf, api_start_is_ready_supported, util_is_dom_content_loaded_done, api_start, api_subscribe, index;
util_window = function () {
  return window;
}();
is_supported = function (window) {
  /**
   * Feature detection for whether mandatory browser features are supported.
   */
  // required for .start() and .end() timing
  // http://caniuse.com/#search=performance.now
  return !!(window.performance && window.performance.now);
}(util_window);
event_stream = [];
api_addReporter = function (eventStream) {
  /**
   * Add a custom reporter to contribute to transition reports.
   *
   * @param {Reporter} reporter
   * @example
   *     api.addReporter(function dateReporter(transition) {
   *         return {
   *             date: Date.now()
   *         };
   *     });
   */
  return function addReporter(reporter) {
    // "addReporter" API has highest priority, so we use .unshift() rather than .push()
    eventStream.unshift({ addReporter: reporter });
  };
}(event_stream);
api_delegateTo = function (eventStream) {
  /**
   * Yield control to another object, giving it all events captured thus far, and all events in the future.
   * @param {function} subscriber
   */
  return function delegateTo(subscriber) {
    while (eventStream.length) {
      subscriber(eventStream.splice(0, 1)[0]);
    }
    eventStream.unshift = subscriber;
    eventStream.push = subscriber;
  };
}(event_stream);
api_end = function (eventStream, window) {
  /**
   * Finish timing and report the results.
   *
   * @param {String} options.key A key that identifies the page that has now finished loading. It must match the
   *     key provided to `start`.
   * @returns {undefined}
   * @example
   *     api.end({key: "jira.issue.view"});
   */
  return function end(options) {
    eventStream.push({
      end: {
        key: options.key,
        timestamp: window.performance.now()
      }
    });
  };
}(event_stream, util_window);
util_matches_selector = function (window) {
  var HTMLElementProto = window.HTMLElement.prototype;
  return HTMLElementProto.matches || HTMLElementProto.msMatchesSelector || HTMLElementProto.webkitMatchesSelector || HTMLElementProto.mozMatchesSelector || HTMLElementProto.oMatchesSelector;
}(util_window);
util_multi_value_map = function () {
  /**
   * A map that supports multiple values per key.
   * @constructor
   */
  function MultiValueMap() {
    this._ = {};
    this.length = 0;
  }
  /**
   * Add an object to a key.
   * @param {string} key
   * @param {*} object
   */
  MultiValueMap.prototype.add = function (key, object) {
    if (!this._.hasOwnProperty(key)) {
      this.length++;
      this._[key] = [];
    }
    this._[key].push(object);
  };
  /**
   * Remove and return an object under a key.
   * @param {string} key
   * @param {*} [object] If specified, only this object will be removed from the values.
   * @returns {boolean} true if an item was removed
   */
  MultiValueMap.prototype.remove = function (key, object) {
    var index;
    var mutated = false;
    if (this._.hasOwnProperty(key)) {
      // When only a key is specified, _all_ values are removed.
      if (arguments.length === 1) {
        delete this._[key];
        mutated = true;  // When a key _and_ object are specified, only remove that object from the
                         // set of values for that key. If as a result, the value set becomes empty,
                         // delete that key from the map.
      } else {
        index = this._[key].indexOf(object);
        if (index > -1) {
          this._[key].splice(index, 1);
          if (this._[key].length === 0) {
            delete this._[key];
          }
          mutated = true;
        }
      }
    }
    return mutated;
  };
  /**
   * Get an array of objects under a key.
   * @param {string} key
   * @returns {*[]}
   */
  MultiValueMap.prototype.get = function (key) {
    if (this._.hasOwnProperty(key)) {
      return this._[key];
    }
    return [];
  };
  /**
   * Iterate over all keys and values.
   * @param {function} callback Called with two arguments: values, key
   * @returns {undefined}
   */
  MultiValueMap.prototype.forEach = function (callback) {
    var items = this._;
    Object.keys(items).forEach(function (key) {
      callback(items[key], key);
    });
  };
  return MultiValueMap;
}();
util_document = function (window) {
  return window.document;
}(util_window);
util_element_hound = function (matchesSelector, MultiValueMap, window, document) {
  var MutationObserver = window.MutationObserver;
  var observer;
  var observing = false;
  var Promise = window.Promise;
  var targets;
  // MutationObserver -- Required for determining whether selectors are satisfied in the DOM;
  // Promise -- Required for combining multiple conditions together.
  if (!(MutationObserver && Promise)) {
    return;
  }
  // A map of selector->[callback] of things to find.
  targets = new MultiValueMap();
  /**
   * Add a target to watch for, ensuring the MutationObserver is enabled.
   * @param {string} selector
   * @param {function} callback
   */
  function addTarget(selector, callback) {
    if (!observing) {
      observer.observe(document, {
        attributes: true,
        childList: true,
        subtree: true
      });
      observing = true;
    }
    targets.add(selector, callback);
  }
  /**
   * Remove a target, shutting down the MutationObserver if possible.
   * @param {string} selector
   * @param {*} [callback]
   */
  function removeTarget(selector, callback) {
    targets.remove.apply(targets, arguments);
    if (targets.length === 0) {
      observer.disconnect();
      observing = false;
    }
  }
  // A MutationObserver so we know when the DOM changes.
  observer = new MutationObserver(function (mutations) {
    mutations.forEach(function (mutation) {
      var isNodesAddedMutation = mutation.type === 'childList' && mutation.addedNodes && mutation.addedNodes.length > 0;
      var isAttributesChangedMutation = mutation.type === 'attributes';
      if (!isNodesAddedMutation && !isAttributesChangedMutation) {
        return;
      }
      // Check nodes that have changed to see if they match any selectors.
      targets.forEach(function (callbacks, selector) {
        if (mutation.target.querySelector(selector) || matchesSelector.call(mutation.target, selector)) {
          callbacks.forEach(function (callback) {
            callback();
          });
          removeTarget(selector);
        }
      });
    });
  });
  /**
   * @typedef {Promise} ElementHound
   * @property {function} dismiss When called, dismissed the hound.
   */
  /**
   * Find some elements!
   *
   * @param {string|string[]} selectors One ore more CSS selectors that must all match elements of interest.
   * @returns {ElementHound}
   * @constructor
   */
  function ElementHound(selectors) {
    var dismiss;
    // Normalise selectors to an array.
    if (!selectors.forEach) {
      selectors = [selectors];
    }
    /**
     * @type {ElementHound}
     */
    var result = new Promise(function (resolve, reject) {
      var requirementPromises = [];
      var requirementCleanups = [];
      selectors.forEach(function (selector) {
        var promise;
        var cleanup;
        if (!document.querySelector(selector)) {
          promise = new Promise(function (resolve) {
            addTarget(selector, resolve);
            cleanup = function () {
              removeTarget(selector, resolve);
            };
          });
          requirementPromises.push(promise);
          requirementCleanups.push(cleanup);
        }
      });
      // Clean-up after ourselves, to reduce the work done by the mutation observer.
      function cleanup() {
        requirementCleanups.forEach(function (requirementCleanup) {
          requirementCleanup();
        });
      }
      Promise.all(requirementPromises).then(cleanup).then(resolve, reject);
      dismiss = function () {
        cleanup();
        reject();
      };
    });
    // Allow the caller to explicitly dismiss the hound. This allows the caller to say
    // they don't care about the result any more, and allows us to stop looking for it.
    result.dismiss = dismiss;
    return result;
  }
  return ElementHound;
}(util_matches_selector, util_multi_value_map, util_window, util_document);
util_element_wolf = function (matchesSelector, MultiValueMap, window, document) {
  var MutationObserver = window.MutationObserver;
  var observer;
  var observing = false;
  var Promise = window.Promise;
  var targets;
  // MutationObserver -- Required for determining whether selectors are satisfied in the DOM;
  // Promise -- Required for combining multiple conditions together.
  if (!(MutationObserver && Promise)) {
    return;
  }
  // A map of selector->[callback] of things to find.
  targets = new MultiValueMap();
  /**
   * Add a target to watch for, ensuring the MutationObserver is enabled.
   * @param {string} selector
   * @param {function} callback
   */
  function addTarget(selector, callback) {
    if (!observing) {
      observer.observe(document, {
        childList: true,
        subtree: true
      });
      observing = true;
    }
    targets.add(selector, callback);
  }
  /**
   * Remove a target, shutting down the MutationObserver if possible.
   * @param {string} selector
   * @param {*} [callback]
   */
  function removeTarget(selector, callback) {
    targets.remove.apply(targets, arguments);
    if (targets.length === 0) {
      observer.disconnect();
      observing = false;
    }
  }
  // A MutationObserver so we know when the DOM changes.
  observer = new MutationObserver(function (mutations) {
    mutations.forEach(function (mutation) {
      var isNodesRemovedMutation = mutation.type === 'childList' && mutation.removedNodes && mutation.removedNodes.length > 0;
      if (isNodesRemovedMutation) {
        targets.forEach(function (callbacks, selector) {
          var removed;
          for (var i = 0; i < mutation.removedNodes.length; i++) {
            removed = mutation.removedNodes[i];
            if (removed.querySelector && (removed.querySelector(selector) || matchesSelector.call(removed, selector))) {
              for (var j = 0; j < callbacks.length; j++) {
                callbacks[j]();
              }
              removeTarget(selector);
            }
          }
        });
      }
    });
  });
  /**
   * @typedef {Promise} ElementWolf
   * @property {function} dismiss When called, dismisses the wolf.
   */
  /**
   * Find some elements!
   *
   * @param {string|string[]} selectors One ore more CSS selectors that must all match elements of interest.
   * @returns {ElementWolf}
   * @constructor
   */
  function ElementWolf(selectors) {
    var dismiss;
    // Normalise selectors to an array.
    if (!selectors.forEach) {
      selectors = [selectors];
    }
    /**
     * @type {ElementWolf}
     */
    var result = new Promise(function (resolve, reject) {
      var requirementPromises = [];
      var requirementCleanups = [];
      selectors.forEach(function (selector) {
        var promise;
        var cleanup;
        if (document.querySelector(selector)) {
          promise = new Promise(function (resolve) {
            addTarget(selector, resolve);
            cleanup = function () {
              removeTarget(selector, resolve);
            };
          });
          requirementPromises.push(promise);
          requirementCleanups.push(cleanup);
        }
      });
      // Clean-up after ourselves, to reduce the work done by the mutation observer.
      function cleanup() {
        requirementCleanups.forEach(function (requirementCleanup) {
          requirementCleanup();
        });
      }
      Promise.all(requirementPromises).then(cleanup).then(resolve, reject);
      dismiss = function () {
        cleanup();
        reject();
      };
    });
    // Allow the caller to explicitly dismiss the hound. This allows the caller to say
    // they don't care about the result any more, and allows us to stop looking for it.
    result.dismiss = dismiss;
    return result;
  }
  return ElementWolf;
}(util_matches_selector, util_multi_value_map, util_window, util_document);
api_start_is_ready_supported = function (ElementHound, ElementWolf) {
  /**
   * Feature detection for whether the .api({ready: …}) API option is supported.
   */
  return !!(ElementHound && ElementWolf);
}(util_element_hound, util_element_wolf);
util_is_dom_content_loaded_done = function (document, window) {
  var done = false;
  document.addEventListener('DOMContentLoaded', function () {
    // setTimeout matters here because the purpose of this module is to let know when all the DOMContentLoaded
    // event handlers have run. In order to know that, it would have to run after all the other handlers have run.
    // Hence we're using setTimeout to wait until the next tick. We know for certain that on the next tick all
    // the handlers have been executed due to JavaScript being single threaded.
    window.setTimeout(function () {
      done = true;
    });
  });
  /**
   * Return true if the DOMContentLoaded event handlers have been called.
   * @returns {boolean}
   */
  function isDOMContentLoadedDone() {
    return done;
  }
  return isDOMContentLoadedDone;
}(util_document, util_window);
api_start = function (end, isReadySupported, eventStream, ElementHound, ElementWolf, isDOMContentLoadedDone, window) {
  var Promise = window.Promise;
  var executeOnceOnStart = [];
  /**
   * In the .start() API, there are multiple short-hand versions of the 'ready' value that can be used. In the
   * interest of sanity, this function normalises them all to the most complex form.
   *
   * @param {string|string[]|{selector: string, requireUpdate: boolean}} conditions
   * @param {boolean} defaultRequireUpdate When a ready condition is a string (i.e. selector only), use this value for
   *     requireUpdate.
   * @returns {Array<{selector: string, requireUpdate: boolean}>}
   */
  function normalisedReady(conditions, defaultRequireUpdate) {
    if (!Array.isArray(conditions)) {
      conditions = [conditions];
    }
    return conditions.map(function (c) {
      return typeof c === 'string' ? {
        selector: c,
        requireUpdate: defaultRequireUpdate
      } : c;
    });
  }
  /**
   * Combine all the ready conditions into a single promise.
   *
   * @param {{selector: string, requireUpdate: boolean}[]} conditions
   * @returns {Promise} a promise that is resolved when all conditions are satisfied
   */
  function combinedReady(conditions) {
    var combined;
    combined = conditions.map(function (condition) {
      var precondition;
      if (condition.requireUpdate) {
        precondition = new ElementWolf(condition.selector);
        // In case another transition happens _before_ we can finish.
        executeOnceOnStart.push(function () {
          precondition.dismiss();
        });
      } else {
        precondition = Promise.resolve();
      }
      return precondition.then(function () {
        var hound = new ElementHound(condition.selector);
        // In case another transition happens _before_ we can finish.
        executeOnceOnStart.push(function () {
          hound.dismiss();
        });
        return hound;
      });
    });
    return Promise.all(combined);
  }
  /**
   * Start measuring the duration of a transition.
   *
   * @param {String} options.key A key that identifies the page where the user is headed.
   * @param {boolean} [options.isInitial] If specified, indicates whether the transition should be treated as a
   *     "full page load" (initial). If not specified, this will be determined automatically based on whether or not
   *     DOMContentLoaded has fired.
   * @param {number} [options.threshold=1000] Declares the target (in milliseconds) duration for the navigation. The
   *     performance of the navigation is considered *good* if it completes within this threshold.
   * @param {String|String[]|{selector: string, requireUpdate: boolean}[]} [options.ready] A CSS selector that matches
   *     one or more DOM elements. When the selector matches something in the DOM, the page is considered "ready" for
   *     the user.
   *
   *     For non-initial page loads, if the selector _immediately_ matches one or more elements in the DOM, it will
   *     first wait a matching element to be removed, and then wait for a DOM mutation to expose a matching element.
   *     This behaviour can be turned off (i.e. don't require an element to be removed first) via the
   *     `requireUpdate=false` option.
   * @returns {undefined}
   * @example
   *     api.start({key: "jira.issue.view"});
   * @example
   *     api.start({
   *         key: "jira.issue.view",
   *         threshold: 1000
   *     });
   * @example
   *     api.start({
   *         key: "jira.issue.view",
   *         ready: ".issue-main-content",
   *         threshold: 1000
   *     });
   * @example
   *     api.start({
   *         key: "jira.issue.view",
   *         ready: [
   *             ".issue-main-content",
   *             ".another-required-thing"
   *         ],
   *         threshold: 1000
   *     });
   * @example
   *     api.start({
   *         key: "jira.issue.view",
   *         ready: [
   *             {selector: ".issue-main-content", requireUpdate: false},
   *             ".another-required-thing"
   *         ],
   *         threshold: 1000
   *     });
   */
  return function start(options) {
    var conditions;
    var isInitial = 'isInitial' in options ? options.isInitial : isDOMContentLoadedDone() === false;
    var threshold = 'threshold' in options ? options.threshold : 1000;
    eventStream.push({
      start: {
        key: options.key,
        isInitial: isInitial,
        threshold: threshold,
        timestamp: isInitial ? 0 : window.performance.now()
      }
    });
    executeOnceOnStart.forEach(function (callback) {
      callback();
    });
    // Empty the array of callbacks now that we've called them.
    executeOnceOnStart.splice(0, executeOnceOnStart.length);
    if (options.ready && isReadySupported) {
      conditions = normalisedReady(options.ready, /*defaultRequireUpdate=*/
      !isInitial);
      combinedReady(conditions).then(function () {
        end({ key: options.key });
      });
    }
  };
}(api_end, api_start_is_ready_supported, event_stream, util_element_hound, util_element_wolf, util_is_dom_content_loaded_done, util_window);
api_subscribe = function (eventStream) {
  /**
   * Add a subscriber that's interested in reports.
   */
  return function subscribe(subscriber) {
    eventStream.push({ subscribe: subscriber });
  };
}(event_stream);
index = function (isSupported, addReporter, delegateTo, end, start, subscribe) {
  var noop = function () {
  };
  return {
    start: isSupported ? start : noop,
    end: isSupported ? end : noop,
    addReporter: isSupported ? addReporter : noop,
    delegateTo: isSupported ? delegateTo : noop,
    subscribe: isSupported ? subscribe : noop
  };
}(is_supported, api_addReporter, api_delegateTo, api_end, api_start, api_subscribe);
window['browser-metrics'] = index;
if (window.define) {
  window.define('internal/browser-metrics', function () {
    return index;
  });
}
}());