/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.user;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.HipChatScope;
import com.atlassian.hipchat.api.session.GenerateTokenResult;
import com.atlassian.plugins.hipchat.ao.AOHipChatLink;
import com.atlassian.plugins.hipchat.ao.AOHipChatUser;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.api.HipChatUserId;
import com.atlassian.plugins.hipchat.api.events.HipChatUserMapped;
import com.atlassian.plugins.hipchat.api.events.HipChatUserUnmapped;
import com.atlassian.plugins.hipchat.api.events.HipChatUserUpdated;
import com.atlassian.plugins.hipchat.user.HipChatAOUserManager;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHipChatAOUserManager
implements HipChatAOUserManager {
    @VisibleForTesting
    static final String USER_KEY_CLAUSE = "USER_KEY = ?";
    static final String HIPCHAT_USER_ID_CLAUSE = "HIP_CHAT_USER_ID = ? AND HIP_CHAT_LINK_ID = ?";
    private final Logger log = LoggerFactory.getLogger(DefaultHipChatAOUserManager.class);
    private final ActiveObjects ao;
    private final EventPublisher eventPublisher;

    public DefaultHipChatAOUserManager(ActiveObjects ao, EventPublisher eventPublisher) {
        this.ao = ao;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public Option<AOHipChatUser> getByUserKey(UserKey userKey) {
        Object[] results = (AOHipChatUser[])this.ao.find(AOHipChatUser.class, Query.select().where(USER_KEY_CLAUSE, new Object[]{userKey.getStringValue()}));
        if (ArrayUtils.isEmpty((Object[])results)) {
            return Option.none();
        }
        if (results.length > 1) {
            this.log.warn("More than one hipchat user found for the given user key {} : {}", (Object)userKey.getStringValue(), (Object)Arrays.toString(results));
        }
        return Option.option((Object)results[0]);
    }

    @Override
    public Iterable<AOHipChatUser> getByHipChatUserId(HipChatUserId hipChatUserId) {
        Object[] results = (AOHipChatUser[])this.ao.find(AOHipChatUser.class, Query.select().where(HIPCHAT_USER_ID_CLAUSE, new Object[]{hipChatUserId.asEntityId(), hipChatUserId.getHipChatLinkId().asEntityId()}));
        if (ArrayUtils.isEmpty((Object[])results)) {
            return Collections.emptyList();
        }
        return Arrays.asList(results);
    }

    @Override
    public Option<AOHipChatUser> findHipChatUserById(HipChatUserId hipChatUserId) {
        Iterable<AOHipChatUser> hipChatUsers = this.getByHipChatUserId(hipChatUserId);
        Option hipChatUserOption = Iterables.first(hipChatUsers);
        return hipChatUserOption;
    }

    @Override
    public Iterable<AOHipChatUser> getAll() {
        Object[] results = (AOHipChatUser[])this.ao.find(AOHipChatUser.class);
        if (ArrayUtils.isEmpty((Object[])results)) {
            return Collections.emptyList();
        }
        return Arrays.asList(results);
    }

    @Override
    public Option<AOHipChatUser> create(UserKey userKey, HipChatUserId hipChatUserId, String hipChatUserName, AOHipChatLink hipchatLink, Option<GenerateTokenResult> generateTokenResults, Set<HipChatScope> scopes) {
        Option<AOHipChatUser> existing = this.getByUserKey(userKey);
        if (existing.isEmpty()) {
            AOHipChatUser user = (AOHipChatUser)this.ao.create(AOHipChatUser.class, new DBParam[0]);
            user.setUserKey(userKey.getStringValue());
            user.setHipChatUserId(hipChatUserId.asEntityId());
            user.setHipChatUserName(hipChatUserName);
            user.setHipChatLink(hipchatLink);
            user.setUserScopes(StringUtils.join(scopes, (char)','));
            if (generateTokenResults.isDefined()) {
                user.setUserToken(((GenerateTokenResult)generateTokenResults.get()).getAccessToken());
                user.setRefreshCode(((GenerateTokenResult)generateTokenResults.get()).getRefreshToken());
                user.setUserTokenExpiry(new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(((GenerateTokenResult)generateTokenResults.get()).getExpiresIn())));
            }
            user.save();
            this.eventPublisher.publish((Object)new HipChatUserMapped(userKey, hipChatUserId));
            return Option.option((Object)user);
        }
        return this.update((AOHipChatUser)existing.get(), userKey, hipChatUserId, hipChatUserName, hipchatLink, generateTokenResults, scopes);
    }

    @Override
    public Option<AOHipChatUser> update(AOHipChatUser user, UserKey userKey, HipChatUserId hipChatUserId, String hipChatUserName, AOHipChatLink hipchatLink, Option<GenerateTokenResult> generateTokenResult, Set<HipChatScope> scopes) {
        Preconditions.checkNotNull((Object)user, (Object)"AOHipChatUser should not be null");
        user.setUserKey(userKey.getStringValue());
        user.setHipChatUserId(hipChatUserId.asEntityId());
        user.setHipChatUserName(hipChatUserName);
        user.setHipChatLink(hipchatLink);
        user.setUserScopes(StringUtils.join(scopes, (char)','));
        if (generateTokenResult.isDefined()) {
            user.setUserToken(((GenerateTokenResult)generateTokenResult.get()).getAccessToken());
            user.setRefreshCode(((GenerateTokenResult)generateTokenResult.get()).getRefreshToken());
            user.setUserTokenExpiry(new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(((GenerateTokenResult)generateTokenResult.get()).getExpiresIn())));
        }
        user.save();
        this.eventPublisher.publish((Object)new HipChatUserUpdated(userKey, hipChatUserId));
        return Option.option((Object)user);
    }

    @Override
    public void updatePersonalToken(AOHipChatUser user, GenerateTokenResult generateTokenResult) {
        Preconditions.checkNotNull((Object)user, (Object)"user should not be null");
        user.setUserToken(generateTokenResult.getAccessToken());
        user.setRefreshCode(generateTokenResult.getRefreshToken());
        user.setUserTokenExpiry(new Date(System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(generateTokenResult.getExpiresIn())));
        user.save();
    }

    @Override
    public void delete(AOHipChatUser user) {
        UserKey userKey = new UserKey(user.getUserKey());
        this.ao.delete(new RawEntity[]{user});
        this.eventPublisher.publish((Object)new HipChatUserUnmapped(userKey));
    }

    @Override
    public Option<Set<HipChatScope>> fetchScopes(AOHipChatUser aoHipChatUser) {
        String userScopes = aoHipChatUser.getUserScopes();
        if (StringUtils.isBlank((String)userScopes)) {
            return Option.none();
        }
        StringTokenizer tokenizer = new StringTokenizer(userScopes, ",");
        HashSet scopesSet = Sets.newHashSetWithExpectedSize((int)tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            Option<HipChatScope> hipChatScopesOption = HipChatScope.fromName(tokenizer.nextToken());
            if (!hipChatScopesOption.isDefined()) continue;
            scopesSet.add(hipChatScopesOption.get());
        }
        return Option.some((Object)scopesSet);
    }

    @Override
    public Option<AOHipChatUser> updateScopes(AOHipChatUser user, Set<HipChatScope> scopes) {
        user.setUserScopes(StringUtils.join(scopes, (char)','));
        user.save();
        UserKey userKey = new UserKey(user.getUserKey());
        HipChatLinkId hcLinkId = new HipChatLinkId(user.getHipChatLink().getID());
        this.eventPublisher.publish((Object)new HipChatUserUpdated(userKey, new HipChatUserId(user.getHipChatUserId(), hcLinkId)));
        return Option.option((Object)user);
    }
}

