/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.link;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.Internal;
import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.HipChatRoutesProvider;
import com.atlassian.hipchat.api.session.SessionService;
import com.atlassian.plugins.hipchat.ao.AOHipChatLink;
import com.atlassian.plugins.hipchat.ao.AOHipChatUser;
import com.atlassian.plugins.hipchat.ao.InternalHipChatLink;
import com.atlassian.plugins.hipchat.api.HipChatDarkFeatureService;
import com.atlassian.plugins.hipchat.api.HipChatLinkId;
import com.atlassian.plugins.hipchat.api.routes.HipChatAPIFactory;
import com.atlassian.plugins.hipchat.link.HipChatAOLinkManager;
import com.atlassian.plugins.hipchat.link.HipChatLinkBuilder;
import com.atlassian.plugins.hipchat.user.HipChatAOUserManager;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.collect.ImmutableList;
import java.util.Date;
import net.java.ao.DBParam;
import net.java.ao.Query;
import net.java.ao.RawEntity;

@Internal
public class DefaultHipChatAOLinkManager
implements HipChatAOLinkManager {
    private final ActiveObjects ao;
    private final HipChatAOUserManager userManager;
    private final HipChatAPIFactory hipChatAPIFactory;
    private final HipChatDarkFeatureService hipChatDarkFeatureService;
    private TransactionTemplate transactionTemplate;

    public DefaultHipChatAOLinkManager(ActiveObjects ao, HipChatAOUserManager userManager, HipChatAPIFactory hipChatAPIFactory, HipChatDarkFeatureService hipChatDarkFeatureService, TransactionTemplate transactionTemplate) {
        this.ao = ao;
        this.userManager = userManager;
        this.hipChatAPIFactory = hipChatAPIFactory;
        this.hipChatDarkFeatureService = hipChatDarkFeatureService;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public void updateAddonToken(HipChatLinkId linkId, String token, Date expiryDate) {
        AOHipChatLink link = (AOHipChatLink)this.ao.get(AOHipChatLink.class, (Object)linkId.asEntityId());
        if (link != null) {
            link.setToken(token);
            link.setAddonTokenExpiry(expiryDate);
            link.save();
        }
    }

    @Override
    public void updateSystemUserToken(HipChatLinkId linkId, String token, Date expiryDate) {
        AOHipChatLink link = (AOHipChatLink)this.ao.get(AOHipChatLink.class, (Object)linkId.asEntityId());
        if (link != null) {
            link.setSystemUserToken(token);
            link.setSystemTokenExpiry(expiryDate);
            link.save();
        }
    }

    @Override
    public void removeLinkById(HipChatLinkId linkId, boolean asPartOfReinstall) {
        AOHipChatLink link = (AOHipChatLink)this.ao.get(AOHipChatLink.class, (Object)linkId.asEntityId());
        if (link != null) {
            for (AOHipChatUser user : link.getMappedUsers()) {
                this.userManager.delete(user);
            }
            this.ao.delete(new RawEntity[]{link});
        }
    }

    @Override
    public Option<AOHipChatLink> getLinkById(HipChatLinkId linkId) {
        AOHipChatLink hipChatLink = (AOHipChatLink)this.ao.get(AOHipChatLink.class, (Object)linkId.asEntityId());
        return Option.option((Object)hipChatLink);
    }

    @Override
    public Option<AOHipChatLink> getLinkByOAuthId(String oauthId) {
        Query query = Query.select().from(AOHipChatLink.class).where("OAUTH_ID = ?", new Object[]{oauthId});
        Object[] links = (AOHipChatLink[])this.ao.find(AOHipChatLink.class, query);
        return Iterables.first((Iterable)ImmutableList.copyOf((Object[])links));
    }

    @Override
    public Iterable<InternalHipChatLink> getLinks() {
        Object[] hipChatLinks = (AOHipChatLink[])this.ao.find(AOHipChatLink.class);
        return ImmutableList.copyOf((Object[])hipChatLinks);
    }

    @Override
    public Option<AOHipChatLink> getLinkByUrlAndGroup(String apiUrl, int groupId) {
        Query query = Query.select().from(AOHipChatLink.class).where("GROUP_ID = ? and API_URL = ?", new Object[]{groupId, apiUrl});
        Object[] links = (AOHipChatLink[])this.ao.find(AOHipChatLink.class, query);
        return Iterables.first((Iterable)ImmutableList.copyOf((Object[])links));
    }

    @Override
    public SessionService makeSessionService(InternalHipChatLink aoHipChatLink, HipChatRoutesProvider.Routes<HipChatAPI.TokenType.CustomToken> routes, UserKey userKey) {
        return this.hipChatAPIFactory.createAPI(HipChatAPI.TokenType.CustomToken.CustomToken, routes, aoHipChatLink, userKey).sessions();
    }

    @Override
    public Option<HipChatAOLinkManager.Builder> newLinkBuilder(HipChatLinkId linkId) {
        Option<AOHipChatLink> linkById = this.getLinkById(linkId);
        if (linkById.isDefined()) {
            return Option.some((Object)this.newLinkBuilder(this.hipChatDarkFeatureService.isHipChatSystemUserEnabled(), (AOHipChatLink)linkById.get()));
        }
        return Option.none();
    }

    @Override
    public HipChatAOLinkManager.Builder newLinkBuilder(boolean systemUserEnabled) {
        return new HipChatLinkBuilder(systemUserEnabled, this, this.transactionTemplate);
    }

    @Override
    public HipChatAOLinkManager.Builder newLinkBuilder(boolean systemUserEnabled, AOHipChatLink existingLink) {
        return new HipChatLinkBuilder(systemUserEnabled, existingLink, this, this.transactionTemplate);
    }

    @Override
    public AOHipChatLink newInstance() {
        return (AOHipChatLink)this.ao.create(AOHipChatLink.class, new DBParam[0]);
    }

    @Override
    public AOHipChatLink saveExisting(AOHipChatLink link) {
        link.save();
        return link;
    }

    @Override
    public AOHipChatLink saveNew(AOHipChatLink link) {
        link.save();
        return link;
    }
}

