/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.routes;

import com.atlassian.annotations.Internal;
import com.atlassian.plugins.hipchat.api.CallbackType;
import com.atlassian.plugins.hipchat.api.routes.HipChatRoutesProvider;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;

@Internal
public class DefaultHipChatRoutesProvider
implements HipChatRoutesProvider {
    public static final String LINK_RESOURCE_PATH = "/installation";
    public static final String OAUTH2_RESOURCE_PATH = "/oauth2";
    public static final String WEBHOOK_RESOURCE_PATH = "/webhook";
    public static final String USER_RESOURCE_PATH = "/user";
    public static final String GROUPS_RESOURCE_PATH = "/groups";
    public static final String DEFAULT_RESOURCE_PATH = "/default";
    public static final String IS_FREE_GROUP_RESOURCE_PATH = "/invitations-allowed";
    private static final String HIPCHAT_ADMIN_BASE = "{baseUrl}/plugins/servlet/hipchat";
    private static final String HIPCHAT_RESOURCE_BASE = "{baseUrl}/rest/hipchat/integration/latest/";
    private static final String HIPCHAT_COMPATIBILITY_BASE = "{baseUrl}/rest/hipchat/compatibility/latest/";
    public static final String FIND_INVITE_USERS_RESOURCE_PATH = "find-invite-users";
    private final ApplicationProperties applicationProperties;

    public DefaultHipChatRoutesProvider(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
    }

    protected String baseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.ABSOLUTE);
    }

    protected String canonicalBaseUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
    }

    protected String relativeUrl() {
        return this.applicationProperties.getBaseUrl(UrlMode.RELATIVE);
    }

    @Override
    public URI getAdminConfigurationPage() {
        return UriBuilder.fromPath((String)HIPCHAT_ADMIN_BASE).path("configure").build(new Object[]{this.baseUrl()});
    }

    @Override
    public URI getAdminInvitePage() {
        return UriBuilder.fromPath((String)HIPCHAT_ADMIN_BASE).path("invite").build(new Object[]{this.baseUrl()});
    }

    @Override
    public URI getUninstall() {
        return UriBuilder.fromPath((String)HIPCHAT_RESOURCE_BASE).path(LINK_RESOURCE_PATH).path("uninstall").build(new Object[]{this.baseUrl()});
    }

    @Override
    public Map<CallbackType, URI> oauth2Callbacks() {
        return ImmutableMap.of((Object)((Object)CallbackType.Oauth2), (Object)UriBuilder.fromPath((String)HIPCHAT_RESOURCE_BASE).path("oauth2/complete").build(new Object[]{this.baseUrl()}));
    }

    @Override
    public URI installCallback() {
        return UriBuilder.fromPath((String)HIPCHAT_ADMIN_BASE).path("configure").build(new Object[]{this.baseUrl()});
    }

    @Override
    public URI self() {
        return URI.create(this.canonicalBaseUrl());
    }

    @Override
    public URI homepage() {
        return URI.create(this.canonicalBaseUrl());
    }

    @Override
    public URI getPingHipChat() {
        return UriBuilder.fromPath((String)HIPCHAT_RESOURCE_BASE).path(LINK_RESOURCE_PATH).path("ping").build(new Object[]{this.relativeUrl()});
    }

    @Override
    public URI getBeginInstall() {
        return UriBuilder.fromPath((String)HIPCHAT_RESOURCE_BASE).path(LINK_RESOURCE_PATH).path("begin").build(new Object[]{this.relativeUrl()});
    }

    @Override
    public URI getCompleteInstall() {
        return UriBuilder.fromPath((String)HIPCHAT_RESOURCE_BASE).path(LINK_RESOURCE_PATH).path("complete").build(new Object[]{this.relativeUrl()});
    }

    @Override
    public URI getBeginOauth2Uri() {
        return UriBuilder.fromPath((String)HIPCHAT_RESOURCE_BASE).path(OAUTH2_RESOURCE_PATH).path("begin").build(new Object[]{this.baseUrl()});
    }

    @Override
    public URI getCompleteOauth2Uri() {
        return UriBuilder.fromPath((String)HIPCHAT_RESOURCE_BASE).path(OAUTH2_RESOURCE_PATH).path("complete").build(new Object[]{this.baseUrl()});
    }

    @Override
    public URI uninstallCallback() {
        return UriBuilder.fromPath((String)HIPCHAT_ADMIN_BASE).path("configure").queryParam("uninstall", new Object[]{true}).build(new Object[]{this.baseUrl()});
    }

    @Override
    public URI webhookCallback(String resourcePath) {
        return UriBuilder.fromPath((String)HIPCHAT_RESOURCE_BASE).path(WEBHOOK_RESOURCE_PATH).path(resourcePath).build(new Object[]{this.canonicalBaseUrl()});
    }

    @Override
    public URI getFindInviteUsersURI() {
        return UriBuilder.fromPath((String)HIPCHAT_COMPATIBILITY_BASE).path(USER_RESOURCE_PATH).path(FIND_INVITE_USERS_RESOURCE_PATH).build(new Object[]{this.baseUrl()});
    }

    @Override
    public URI getIsInvitationsToGroupAllowedURI() {
        return UriBuilder.fromPath((String)HIPCHAT_RESOURCE_BASE).path(GROUPS_RESOURCE_PATH).path(DEFAULT_RESOURCE_PATH).path(IS_FREE_GROUP_RESOURCE_PATH).build(new Object[]{this.baseUrl()});
    }
}

