/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.room;

import com.atlassian.fugue.Iterables;
import com.atlassian.fugue.Option;
import com.atlassian.hipchat.api.HipChatAPI;
import com.atlassian.hipchat.api.Result;
import com.atlassian.hipchat.api.rooms.AllRoomsResult;
import com.atlassian.hipchat.api.rooms.CollapsedRoom;
import com.atlassian.hipchat.api.rooms.ExpandedRoom;
import com.atlassian.hipchat.api.webhooks.Message;
import com.atlassian.plugins.hipchat.api.HipChatUserId;
import com.atlassian.plugins.hipchat.api.room.HipChatRoomsProvider;
import com.atlassian.util.concurrent.Promise;
import com.atlassian.util.concurrent.Promises;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class DefaultHipChatRoomsProvider
implements HipChatRoomsProvider {
    private static final int PAGE_SIZE = Integer.parseInt(System.getProperty("hipchat.api.rooms.page_size", "1000"));
    private static final int BATCH_SIZE = Integer.parseInt(System.getProperty("hipchat.api.rooms.batch_size", "2"));
    private static final Function<Result<ExpandedRoom>, Result<ExpandedRoom>> FILTER_PRIVATE_ROOM = new Function<Result<ExpandedRoom>, Result<ExpandedRoom>>(){

        public Result<ExpandedRoom> apply(Result<ExpandedRoom> input) {
            ExpandedRoom expandedRoom;
            if (input.isSuccess() && (expandedRoom = input.success()).isPrivate()) {
                return Result.error("Private room, please confirm access to your HipChat account.", Response.Status.FORBIDDEN.getStatusCode());
            }
            return input;
        }
    };

    @Override
    public Promise<Result<List<CollapsedRoom>>> getAllRooms(HipChatAPI hipChatAPI) {
        return this.getAllRooms(hipChatAPI, false);
    }

    @Override
    public Promise<Result<List<CollapsedRoom>>> getAllRooms(HipChatAPI hipChatAPI, boolean includePrivate) {
        Preconditions.checkNotNull((Object)hipChatAPI);
        return this.getRooms(hipChatAPI, 0, (ImmutableList.Builder<CollapsedRoom>)ImmutableList.builder(), includePrivate);
    }

    @Override
    public Promise<Map<String, Result<ExpandedRoom>>> expandRoomsForIds(HipChatAPI hipChatAPI, Iterable<String> roomIds) {
        Preconditions.checkNotNull((Object)hipChatAPI);
        Preconditions.checkNotNull(roomIds);
        return this.expandRoomsForIds(hipChatAPI, roomIds, (ImmutableMap.Builder<String, Result<ExpandedRoom>>)ImmutableMap.builder());
    }

    @Override
    public Promise<Result<ExpandedRoom>> createRoom(HipChatAPI hipChatAPI, String name, HipChatUserId owner, Option<String> topic) {
        Preconditions.checkNotNull((Object)hipChatAPI);
        Preconditions.checkNotNull((Object)name);
        return hipChatAPI.rooms().createRoom(name, owner.asEntityId(), topic, (Option<Boolean>)Option.none(), (Option<String>)Option.none());
    }

    @Override
    public Promise<Result<Void>> deleteRoom(HipChatAPI hipChatAPI, String roomNameOrId) {
        Preconditions.checkNotNull((Object)hipChatAPI);
        Preconditions.checkNotNull((Object)roomNameOrId);
        return hipChatAPI.rooms().deleteRoom(roomNameOrId);
    }

    @Override
    public Promise<Result<Message>> getRoomMessage(HipChatAPI hipChatAPI, String roomId, String messageId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)roomId), (Object)"roomId can not be null or empty.");
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)messageId), (Object)"messageId can not be null or empty.");
        return hipChatAPI.rooms().getRoomMessage(roomId, messageId);
    }

    private Promise<Map<String, Result<ExpandedRoom>>> expandRoomsForIds(HipChatAPI hipChatAPI, Iterable<String> roomIds, ImmutableMap.Builder<String, Result<ExpandedRoom>> results) {
        ImmutableList.Builder builder = ImmutableList.builder();
        boolean usingPersonalToken = hipChatAPI.getTokenType() instanceof HipChatAPI.TokenType.PersonalToken;
        for (String roomId : Iterables.take((int)BATCH_SIZE, roomIds)) {
            Promise roomPromise = hipChatAPI.rooms().getRoom(roomId);
            if (!usingPersonalToken) {
                roomPromise = roomPromise.map(FILTER_PRIVATE_ROOM);
            }
            builder.add((Object)roomPromise.map(this.toRoomResult(roomId)));
        }
        return Promises.when((Iterable)builder.build()).flatMap(this.expandRoomBatch(hipChatAPI, roomIds, results));
    }

    private Function<List<RoomResult>, Promise<Map<String, Result<ExpandedRoom>>>> expandRoomBatch(final HipChatAPI hipChatAPI, final Iterable<String> roomIds, final ImmutableMap.Builder<String, Result<ExpandedRoom>> results) {
        return new Function<List<RoomResult>, Promise<Map<String, Result<ExpandedRoom>>>>(){

            public Promise<Map<String, Result<ExpandedRoom>>> apply(List<RoomResult> input) {
                for (RoomResult result : input) {
                    results.put((Object)result.roomId, result.expandedRoom);
                }
                Iterable remaining = Iterables.drop((int)BATCH_SIZE, (Iterable)roomIds);
                if (!com.google.common.collect.Iterables.isEmpty((Iterable)remaining)) {
                    return DefaultHipChatRoomsProvider.this.expandRoomsForIds(hipChatAPI, remaining, (ImmutableMap.Builder<String, Result<ExpandedRoom>>)results);
                }
                return Promises.promise((Object)results.build());
            }
        };
    }

    private Function<? super List<RoomResult>, ? extends Map<String, Result<ExpandedRoom>>> mapToResultMap() {
        return new Function<List<RoomResult>, Map<String, Result<ExpandedRoom>>>(){

            public Map<String, Result<ExpandedRoom>> apply(List<RoomResult> input) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (RoomResult roomResult : input) {
                    builder.put((Object)roomResult.roomId, roomResult.expandedRoom);
                }
                return builder.build();
            }
        };
    }

    private Function<Result<ExpandedRoom>, RoomResult> toRoomResult(final String roomId) {
        return new Function<Result<ExpandedRoom>, RoomResult>(){

            public RoomResult apply(Result<ExpandedRoom> result) {
                return new RoomResult(roomId, result);
            }
        };
    }

    private Promise<Result<List<CollapsedRoom>>> getRooms(HipChatAPI hipChatAPI, int startIndex, ImmutableList.Builder<CollapsedRoom> currentRooms, boolean includePrivate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < BATCH_SIZE; ++i) {
            builder.add(hipChatAPI.rooms().getAllRooms().startIndex(startIndex + i * PAGE_SIZE).maxResults(PAGE_SIZE).includePrivate(includePrivate).build());
        }
        return Promises.when((Iterable)builder.build()).flatMap(this.toRoomList(hipChatAPI, startIndex, currentRooms, includePrivate));
    }

    private Function<List<Result<AllRoomsResult>>, Promise<Result<List<CollapsedRoom>>>> toRoomList(final HipChatAPI hipChatAPI, final int startIndex, final ImmutableList.Builder<CollapsedRoom> currentRooms, final boolean includePrivate) {
        return new Function<List<Result<AllRoomsResult>>, Promise<Result<List<CollapsedRoom>>>>(){

            public Promise<Result<List<CollapsedRoom>>> apply(List<Result<AllRoomsResult>> input) {
                for (Result<AllRoomsResult> result : input) {
                    if (result.isError()) {
                        return Promises.promise(result.asError());
                    }
                    AllRoomsResult roomResult = result.success();
                    currentRooms.addAll(roomResult.getRooms());
                    if (roomResult.hasMore()) continue;
                    return Promises.promise(Result.success(currentRooms.build()));
                }
                return DefaultHipChatRoomsProvider.this.getRooms(hipChatAPI, startIndex + PAGE_SIZE * BATCH_SIZE, (ImmutableList.Builder<CollapsedRoom>)currentRooms, includePrivate);
            }
        };
    }

    private static class RoomResult {
        final String roomId;
        final Result<ExpandedRoom> expandedRoom;

        private RoomResult(String roomId, Result<ExpandedRoom> expandedRoom) {
            this.roomId = roomId;
            this.expandedRoom = expandedRoom;
        }
    }
}

