/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.hipchat.api.client;

import com.atlassian.annotations.Internal;
import com.atlassian.plugins.hipchat.api.client.HipChatClientProvider;
import com.atlassian.plugins.hipchat.api.client.ProxyingHttpURLConnectionFactory;
import com.atlassian.plugins.hipchat.api.client.RateLimitMonitoringClientFilter;
import com.atlassian.plugins.hipchat.api.client.RateLimitStateService;
import com.atlassian.plugins.hipchat.util.SecurityUtil;
import com.atlassian.util.concurrent.LazyReference;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Throwables;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import com.sun.jersey.client.urlconnection.HttpURLConnectionFactory;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

@Internal
public class DefaultHipChatClientProvider
implements HipChatClientProvider,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultHipChatClientProvider.class);
    public static final int DEFAULT_THREAD_POOL_SIZE = 8;
    public static final int DEFAULT_QUEUE_SIZE = 10000;
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLISECONDS = 10000;
    public static final int DEFAULT_READ_TIMEOUT_MILLISECONDS = 10000;
    private final int threadPoolSize;
    private final int queueSize;
    private final boolean disregardSslVerification;
    private final Integer connectionTimeout;
    private final Integer readTimeout;
    private ClientFilter rateLimitMonitoringFilter;
    private LazyReference<Client> client = new LazyReference<Client>(){

        protected Client create() throws Exception {
            DefaultClientConfig clientConfig = new DefaultClientConfig();
            clientConfig.getClasses().add(JacksonJsonProvider.class);
            Map clientProperties = clientConfig.getProperties();
            clientProperties.put("com.sun.jersey.client.property.threadpoolSize", DefaultHipChatClientProvider.this.threadPoolSize);
            clientProperties.put("com.sun.jersey.client.property.connectTimeout", DefaultHipChatClientProvider.this.connectionTimeout);
            clientProperties.put("com.sun.jersey.client.property.readTimeout", DefaultHipChatClientProvider.this.readTimeout);
            if (DefaultHipChatClientProvider.this.disregardSslVerification) {
                try {
                    clientProperties.put("com.sun.jersey.client.impl.urlconnection.httpsProperties", new HTTPSProperties(new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession sslSession) {
                            return true;
                        }
                    }, SecurityUtil.getIgnoreCertSSLContext()));
                }
                catch (NoSuchAlgorithmException e) {
                    Throwables.propagate((Throwable)e);
                }
                catch (KeyManagementException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
            Client client = new Client((ClientHandler)new URLConnectionClientHandler((HttpURLConnectionFactory)new ProxyingHttpURLConnectionFactory()), (ClientConfig)clientConfig);
            client.setExecutorService(DefaultHipChatClientProvider.this.createBoundedExecutorService());
            client.addFilter(DefaultHipChatClientProvider.this.rateLimitMonitoringFilter);
            return client;
        }
    };

    public DefaultHipChatClientProvider(RateLimitStateService rateLimitStateService) {
        this.disregardSslVerification = Boolean.valueOf(System.getProperty("hipchat.client.ignoressl.validation", "false"));
        this.threadPoolSize = Integer.getInteger("hipchat.client.threadpool.size", 8);
        this.queueSize = Integer.getInteger("hipchat.client.queue.size", 10000);
        this.connectionTimeout = Integer.getInteger("hipchat.client.timeouts.connect.millis", 10000);
        this.readTimeout = Integer.getInteger("hipchat.client.timeouts.read.millis", 10000);
        this.rateLimitMonitoringFilter = new RateLimitMonitoringClientFilter(rateLimitStateService);
    }

    @Override
    public Client get() {
        return (Client)this.client.get();
    }

    private ExecutorService createBoundedExecutorService() {
        return new ThreadPoolExecutor(this.threadPoolSize, this.threadPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.queueSize), ThreadFactories.namedThreadFactory((String)"hipchat-client", (ThreadFactories.Type)ThreadFactories.Type.DAEMON), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable task, ThreadPoolExecutor executor) {
                log.debug("Task '{}' rejected from thread pool executor '{}'.", (Object)task.toString(), (Object)executor.toString());
            }
        });
    }

    public void destroy() throws Exception {
        if (this.client.isInitialized()) {
            ((Client)this.client.get()).getExecutorService().shutdown();
        }
    }
}

