/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.hipchat.api.connect.descriptor;

import com.atlassian.hipchat.api.HipChatScope;
import com.atlassian.hipchat.api.connect.descriptor.ConnectDescriptorCapabilities;
import com.atlassian.hipchat.api.connect.descriptor.ConnectDescriptorCompatibility;
import com.atlassian.hipchat.api.connect.descriptor.Contracts;
import com.atlassian.hipchat.api.connect.descriptor.HipChatApiConsumer;
import com.atlassian.hipchat.api.connect.descriptor.SynchronisationClassification;
import com.atlassian.hipchat.api.connect.descriptor.Vendor;
import com.atlassian.util.concurrent.Nullable;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"name", "description", "key", "vendor", "links", "capabilities"})
public class ConnectDescriptor {
    private static final String HOME_PAGE_LINK_PROPERTY_NAME = "homepage";
    private static final String SELF_LINK_PROPERTY_NAME = "self";
    private static final Logger log = LoggerFactory.getLogger(ConnectDescriptor.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final String name;
    private final String description;
    private final String key;
    private final Vendor vendor;
    private final Map<String, URI> links;
    private final ConnectDescriptorCapabilities capabilities;
    private URI selfLink;
    private URI homePageLink;

    @JsonCreator
    public ConnectDescriptor(@JsonProperty(value="name") String name, @JsonProperty(value="description") String description, @JsonProperty(value="key") String key, @JsonProperty(value="capabilities") ConnectDescriptorCapabilities capabilities, @JsonProperty(value="vendor") Vendor vendor, @JsonProperty(value="links") Map<String, URI> links) {
        this.name = name;
        this.description = description;
        this.key = key;
        this.vendor = vendor;
        this.links = links;
        this.capabilities = capabilities;
        this.selfLink = links.get(SELF_LINK_PROPERTY_NAME);
        this.homePageLink = links.get(HOME_PAGE_LINK_PROPERTY_NAME);
    }

    private ConnectDescriptor(String name, String description, String key, ConnectDescriptorCapabilities capabilities, Vendor vendor, URI selfLink, URI homePageLink) {
        this.name = Contracts.checkNotNil(name, "Name should not be nil");
        this.description = Contracts.checkNotNil(description, "Description should not be nil");
        this.key = Contracts.checkNotNil(key, "Key should not be nil");
        this.vendor = vendor;
        this.selfLink = Contracts.checkNotNil(selfLink, "Self link should not be nil");
        this.homePageLink = homePageLink;
        this.links = homePageLink == null ? ImmutableMap.of((Object)SELF_LINK_PROPERTY_NAME, (Object)selfLink) : ImmutableMap.of((Object)SELF_LINK_PROPERTY_NAME, (Object)selfLink, (Object)HOME_PAGE_LINK_PROPERTY_NAME, (Object)homePageLink);
        this.capabilities = (ConnectDescriptorCapabilities)Preconditions.checkNotNull((Object)capabilities, (Object)"Capabilities should not be null");
    }

    @JsonIgnore
    public URI getSelfLink() {
        return this.selfLink;
    }

    @JsonIgnore
    public URI getHomePageLink() {
        return this.homePageLink;
    }

    public Map<String, URI> getLinks() {
        return this.links;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getKey() {
        return this.key;
    }

    public ConnectDescriptorCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Nullable
    public Vendor getVendor() {
        return this.vendor;
    }

    @JsonIgnore
    public Set<HipChatScope> getScopes() {
        ConnectDescriptorCapabilities capabilities = this.getCapabilities();
        if (capabilities == null) {
            return HipChatScope.EMPTY_SCOPES_SET;
        }
        HipChatApiConsumer hipChatApiConsumer = capabilities.getHipchatApiConsumer();
        if (hipChatApiConsumer == null) {
            return HipChatScope.EMPTY_SCOPES_SET;
        }
        HipChatScope[] scopes = hipChatApiConsumer.getScopes();
        ImmutableSet immutableScopes = ImmutableSet.copyOf((Object[])scopes);
        return immutableScopes;
    }

    public static ConnectDescriptor cloneWithLimitedScopes(ConnectDescriptor fromConnectDescriptor, Set<HipChatScope> scopes) {
        ConnectDescriptorCapabilities fromCapabilities = fromConnectDescriptor.getCapabilities();
        ConnectDescriptorCapabilities clonedCapabilities = ConnectDescriptorCapabilities.cloneWithLimitedScopes(fromCapabilities, scopes);
        ConnectDescriptor clonedDescriptor = new Builder().setKey(fromConnectDescriptor.getKey()).setName(fromConnectDescriptor.getName()).setDescription(fromConnectDescriptor.getDescription()).setVendor(fromConnectDescriptor.getVendor()).setSelfLink(fromConnectDescriptor.getSelfLink()).setHomePageLink(fromConnectDescriptor.getHomePageLink()).setCapabilities(clonedCapabilities).build();
        return clonedDescriptor;
    }

    public static Map<SynchronisationClassification, ConnectDescriptor> computeCategorisedCompatibilities(ConnectDescriptor fromConnectDescriptor, ConnectDescriptor toConnectDescriptor) {
        Preconditions.checkNotNull((Object)toConnectDescriptor);
        EnumMap<SynchronisationClassification, ConnectDescriptor> compatibilitiesToDescriptors = new EnumMap<SynchronisationClassification, ConnectDescriptor>(SynchronisationClassification.class);
        if (fromConnectDescriptor == null) {
            compatibilitiesToDescriptors.put(SynchronisationClassification.USER_APPROVED, toConnectDescriptor);
        } else {
            ConnectDescriptorCompatibility compatibility = ConnectDescriptor.computeCompatibility(fromConnectDescriptor, toConnectDescriptor);
            if (compatibility != ConnectDescriptorCompatibility.COMPATIBLE) {
                log.warn("Detected changes in HipChat Connect Descriptor [{}]", (Object)compatibility);
            }
            if (compatibility == ConnectDescriptorCompatibility.IDENTITY_CHANGE || compatibility == ConnectDescriptorCompatibility.SCOPE_INCREASE) {
                Builder originalPlusCapabilities = ConnectDescriptor.builder();
                ConnectDescriptor.applyCapabilityChanges(fromConnectDescriptor, toConnectDescriptor, originalPlusCapabilities);
                compatibilitiesToDescriptors.put(SynchronisationClassification.AUTOMATIC, originalPlusCapabilities.build());
                compatibilitiesToDescriptors.put(SynchronisationClassification.USER_APPROVED, toConnectDescriptor);
            } else {
                SynchronisationClassification synchronisationClassification = compatibility.getSynchronisationClassification();
                compatibilitiesToDescriptors.put(synchronisationClassification, toConnectDescriptor);
            }
        }
        return compatibilitiesToDescriptors;
    }

    private static void applyCapabilityChanges(ConnectDescriptor fromConnectDescriptor, ConnectDescriptor toConnectDescriptor, Builder originalPlusCapabilities) {
        ConnectDescriptorCapabilities.Builder capabilitiesBuilder = ConnectDescriptorCapabilities.builder();
        ConnectDescriptorCapabilities.applyCapabilityChanges(fromConnectDescriptor.capabilities, toConnectDescriptor.capabilities, capabilitiesBuilder);
        originalPlusCapabilities.setKey(fromConnectDescriptor.getKey()).setName(toConnectDescriptor.getName()).setDescription(toConnectDescriptor.getDescription()).setVendor(toConnectDescriptor.getVendor()).setSelfLink(fromConnectDescriptor.getSelfLink()).setHomePageLink(fromConnectDescriptor.getHomePageLink()).setCapabilities(capabilitiesBuilder.build());
    }

    public static ConnectDescriptorCompatibility computeCompatibility(ConnectDescriptor fromConnectDescriptor, ConnectDescriptor toConnectDescriptor) {
        if (toConnectDescriptor == null) {
            return ConnectDescriptorCompatibility.COMPATIBLE;
        }
        if (fromConnectDescriptor == null) {
            return ConnectDescriptorCompatibility.SCOPE_INCREASE;
        }
        ConnectDescriptorCompatibility compatibility = ConnectDescriptorCapabilities.computeCompatibility(fromConnectDescriptor.capabilities, toConnectDescriptor.capabilities);
        if (!fromConnectDescriptor.key.equals(toConnectDescriptor.key) || !fromConnectDescriptor.links.equals(toConnectDescriptor.links)) {
            compatibility = ConnectDescriptorCompatibility.mostIncompatible(compatibility, ConnectDescriptorCompatibility.IDENTITY_CHANGE);
        }
        if (!fromConnectDescriptor.name.equals(toConnectDescriptor.name)) {
            compatibility = ConnectDescriptorCompatibility.mostIncompatible(compatibility, ConnectDescriptorCompatibility.META_DATA_CHANGE);
        }
        if (!fromConnectDescriptor.description.equals(toConnectDescriptor.description)) {
            compatibility = ConnectDescriptorCompatibility.mostIncompatible(compatibility, ConnectDescriptorCompatibility.META_DATA_CHANGE);
        }
        if (fromConnectDescriptor.vendor != null || toConnectDescriptor.vendor != null) {
            if (fromConnectDescriptor.vendor == null && toConnectDescriptor.vendor != null) {
                compatibility = ConnectDescriptorCompatibility.mostIncompatible(compatibility, ConnectDescriptorCompatibility.META_DATA_CHANGE);
            } else if (fromConnectDescriptor.vendor != null && toConnectDescriptor.vendor == null) {
                compatibility = ConnectDescriptorCompatibility.mostIncompatible(compatibility, ConnectDescriptorCompatibility.META_DATA_CHANGE);
            } else if (!fromConnectDescriptor.vendor.equals(toConnectDescriptor.vendor)) {
                compatibility = ConnectDescriptorCompatibility.mostIncompatible(compatibility, ConnectDescriptorCompatibility.META_DATA_CHANGE);
            }
        }
        return compatibility;
    }

    public String toJson() {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ConnectDescriptor parseJson(String connectDescriptorJson) {
        try {
            return (ConnectDescriptor)OBJECT_MAPPER.readValue(connectDescriptorJson, ConnectDescriptor.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectDescriptor)) {
            return false;
        }
        ConnectDescriptor that = (ConnectDescriptor)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        if (this.key != null ? !this.key.equals(that.key) : that.key != null) {
            return false;
        }
        if (this.vendor != null ? !this.vendor.equals(that.vendor) : that.vendor != null) {
            return false;
        }
        if (this.links != null ? !this.links.equals(that.links) : that.links != null) {
            return false;
        }
        return !(this.capabilities == null ? that.capabilities != null : !this.capabilities.equals(that.capabilities));
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.vendor != null ? this.vendor.hashCode() : 0);
        result = 31 * result + (this.links != null ? this.links.hashCode() : 0);
        result = 31 * result + (this.capabilities != null ? this.capabilities.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ConnectDescriptor{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", key='" + this.key + '\'' + ", vendor=" + this.vendor + ", links=" + this.links + ", capabilities=" + this.capabilities + '}';
    }

    public static class Builder {
        private String name;
        private String description;
        private String key;
        private Vendor vendor;
        private URI selfLink;
        private URI homePageLink;
        private ConnectDescriptorCapabilities capabilities;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setVendor(Vendor vendor) {
            this.vendor = vendor;
            return this;
        }

        public Builder setSelfLink(URI selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        public Builder setHomePageLink(URI homePageLink) {
            this.homePageLink = homePageLink;
            return this;
        }

        public Builder setCapabilities(ConnectDescriptorCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public ConnectDescriptor build() {
            if (this.capabilities == null) {
                this.capabilities = new ConnectDescriptorCapabilities.Builder().build();
            }
            return new ConnectDescriptor(this.name, this.description, this.key, this.capabilities, this.vendor, this.selfLink, this.homePageLink);
        }
    }
}

