/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.beehive.compat;

import com.google.common.base.Preconditions;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class OptionalService<T>
implements InitializingBean,
DisposableBean {
    private final Class<T> type;
    private final ServiceTracker tracker;

    public OptionalService(BundleContext bundleContext, Class<T> type) {
        this.type = (Class)Preconditions.checkNotNull(type, (Object)"type");
        this.tracker = new ServiceTracker(bundleContext, type.getName(), null);
    }

    protected final T getService() {
        return this.type.cast(this.tracker.getService());
    }

    public void afterPropertiesSet() throws Exception {
        this.tracker.open();
    }

    public final void destroy() {
        this.tracker.close();
    }
}

