// node_modules/@atlassian/aui/src/js/aui/set-visible.js
(typeof window === 'undefined' ? global : window).__8b033618237756b79bd62085f449034f = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  Object.defineProperty(exports, "__esModule", {
      value: true
  });
  
  var _jquery = __205998b249afc65053be53fe079b2622;
  
  var _jquery2 = _interopRequireDefault(_jquery);
  
  var _deprecation = __bec41a89fad5278f895ed424cdf50be7;
  
  var _globalize = __90e6b3a7b5f251fe6bee9d0accee9418;
  
  var _globalize2 = _interopRequireDefault(_globalize);
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  /**
   * Shortcut function adds or removes 'hidden' classname to an element based on a passed boolean.
   *
   * @param {String | Element} element The element or an ID to show or hide.
   * @param {boolean} show true to show, false to hide.
   *
   * @returns {undefined}
   */
  function setVisible(element, show) {
      if (!(element = (0, _jquery2.default)(element))) {
          return;
      }
  
      (0, _jquery2.default)(element).each(function () {
          var isHidden = (0, _jquery2.default)(this).hasClass('hidden');
  
          if (isHidden && show) {
              (0, _jquery2.default)(this).removeClass('hidden');
          } else if (!isHidden && !show) {
              (0, _jquery2.default)(this).addClass('hidden');
          }
      });
  }
  
  var setVisible = (0, _deprecation.fn)(setVisible, 'setVisible', {
      sinceVersion: '5.9.0',
      extraInfo: 'No alternative will be provided. Use jQuery.addClass() / removeClass() instead.'
  });
  
  (0, _globalize2.default)('setVisible', setVisible);
  
  exports.default = setVisible;
  module.exports = exports['default'];
  
  return module.exports;
}).call(this);