// node_modules/@atlassian/aui/src/js/aui/results-list.js
(typeof window === 'undefined' ? global : window).__54dae74e6390f9b11029cb016cb50014 = (function () {
  var module = {
    exports: {}
  };
  var exports = module.exports;
  
  'use strict';
  
  Object.defineProperty(exports, "__esModule", {
      value: true
  });
  
  var _underscore = __65c5c9d6761cf79ad357a1b86523b68f;
  
  var _underscore2 = _interopRequireDefault(_underscore);
  
  var _backbone = __8bce1189c6f418154922d6191fc8f5b9;
  
  var _backbone2 = _interopRequireDefault(_backbone);
  
  var _globalize = __90e6b3a7b5f251fe6bee9d0accee9418;
  
  var _globalize2 = _interopRequireDefault(_globalize);
  
  var _resultSet = __bd8e549d67e5d87221c5fc77fbcfa09b;
  
  var _resultSet2 = _interopRequireDefault(_resultSet);
  
  function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
  
  var ResultsList = _backbone2.default.View.extend({
      events: {
          'click [data-id]': 'setSelection'
      },
  
      initialize: function initialize(options) {
          if (!this.model) {
              this.model = new _resultSet2.default({ source: options.source });
          }
  
          if (!(this.model instanceof _resultSet2.default)) {
              throw new Error('model must be set to a ResultSet');
          }
  
          this.model.bind('update', this.process, this);
  
          this.render = _underscore2.default.wrap(this.render, function (func) {
              this.trigger('rendering');
              func.apply(this, arguments);
              this.trigger('rendered');
          });
      },
  
      process: function process() {
          if (!this._shouldShow(this.model.get('query'))) {
              return;
          }
          this.show();
      },
  
      render: function render() {
          var ul = _backbone2.default.$('<ul/>');
          this.model.each(function (model) {
              var li = _backbone2.default.$('<li/>').attr('data-id', model.id).html(this.renderItem(model)).appendTo(ul);
          }, this);
          this.$el.html(ul);
          return this;
      },
  
      renderItem: function renderItem() {
          return;
      },
  
      setSelection: function setSelection(event) {
          var id = event.target.getAttribute('data-id');
          var selected = this.model.setActive(id);
          this.trigger('selected', selected);
      },
  
      show: function show() {
          this.lastQuery = this.model.get('query');
          this._hiddenQuery = null;
          this.render();
          this.$el.show();
      },
  
      hide: function hide() {
          this.$el.hide();
          this._hiddenQuery = this.lastQuery;
      },
  
      size: function size() {
          return this.model.get('length');
      },
  
      _shouldShow: function _shouldShow(query) {
          return query === '' || !(this._hiddenQuery && this._hiddenQuery === query);
      }
  });
  
  (0, _globalize2.default)('ResultsList', ResultsList);
  
  exports.default = ResultsList;
  module.exports = exports['default'];
  
  return module.exports;
}).call(this);